/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class TestFileInputFormat
extends TestCase {
    public void testAddInputPath() throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "s3://abc:xyz@hostname/");
        Job j = new Job(conf);
        FileSystem defaultfs = FileSystem.get((Configuration)conf);
        System.out.println("defaultfs.getUri() = " + defaultfs.getUri());
        Path original = new Path("file:/foo");
        System.out.println("original = " + original);
        FileInputFormat.addInputPath((Job)j, (Path)original);
        Path[] results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        TestFileInputFormat.assertEquals((int)1, (int)results.length);
        TestFileInputFormat.assertEquals((Object)original, (Object)results[0]);
        original = new Path("file:/bar");
        System.out.println("original = " + original);
        FileInputFormat.setInputPaths((Job)j, (Path[])new Path[]{original});
        results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        TestFileInputFormat.assertEquals((int)1, (int)results.length);
        TestFileInputFormat.assertEquals((Object)original, (Object)results[0]);
    }

    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat();
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)"test");
        List splits = inFormat.getSplits((JobContext)job);
        TestFileInputFormat.assertEquals((int)1, (int)splits.size());
        FileSplit fileSplit = (FileSplit)splits.get(0);
        TestFileInputFormat.assertEquals((int)0, (int)fileSplit.getLocations().length);
        TestFileInputFormat.assertEquals((String)file.getName(), (String)fileSplit.getPath().getName());
        TestFileInputFormat.assertEquals((long)0L, (long)fileSplit.getStart());
        TestFileInputFormat.assertEquals((long)0L, (long)fileSplit.getLength());
        fileSys.delete(file.getParent(), true);
    }

    private class DummyInputFormat
    extends FileInputFormat<Text, Text> {
        private DummyInputFormat() {
        }

        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return null;
        }
    }
}

