/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HdfsBlockLocation;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class TestCombineFileInputFormat
extends TestCase {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2"};
    private static final String[] hosts2 = new String[]{"host2.rack2.com"};
    private static final String[] rack3 = new String[]{"/r3"};
    private static final String[] hosts3 = new String[]{"host3.rack3.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");
    final Path dir1 = new Path(this.inDir, "/dir1");
    final Path dir2 = new Path(this.inDir, "/dir2");
    final Path dir3 = new Path(this.inDir, "/dir3");
    final Path dir4 = new Path(this.inDir, "/dir4");
    final Path dir5 = new Path(this.inDir, "/dir5");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final String DUMMY_FS_URI = "dummyfs:///";
    private static final Log LOG = LogFactory.getLog(TestCombineFileInputFormat.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitPlacement() throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        Object mr = null;
        DistributedFileSystem fileSys = null;
        String testName = "TestSplitPlacement";
        try {
            int i;
            JobConf conf = new JobConf();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster((Configuration)conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file1, (short)1, 1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file5, (short)1, 1);
            DummyInputFormat inFormat = new DummyInputFormat();
            JobConf job = new JobConf((Configuration)conf);
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir5));
            InputSplit[] splits = inFormat.getSplits(job, 1);
            System.out.println("Made splits(Test0): " + splits.length);
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)1);
            CombineFileSplit fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file5.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes((Configuration)conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file2, (short)2, 2);
            inFormat = new DummyInputFormat();
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits(conf, 1);
            System.out.println("Made splits(Test1): " + splits.length);
            fileSplit = null;
            for (int i2 = 0; i2 < splits.length; ++i2) {
                fileSplit = (CombineFileSplit)splits[i2];
                System.out.println("File split(Test1): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)2);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            dfs.startDataNodes((Configuration)conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3");
            TestCombineFileInputFormat.writeFile((Configuration)conf, new Path(this.dir3 + "/file3"), (short)3, 3);
            inFormat = new DummyInputFormat();
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits(conf, 1);
            for (int i3 = 0; i3 < splits.length; ++i3) {
                fileSplit = (CombineFileSplit)splits[i3];
                System.out.println("File split(Test2): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            Path file4 = new Path(this.dir4 + "/file4");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file4, (short)3, 3);
            inFormat = new DummyInputFormat();
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test3): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(2048L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test4): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)5);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(3072L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test5): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)4);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host2.rack2.com");
            fileSplit = (CombineFileSplit)splits[3];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host1.rack1.com");
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(4096L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test6): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)4);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)4);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(3).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(3), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(3), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host2.rack2.com");
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(7168L);
            inFormat.setMinSplitSizeNode(3072L);
            inFormat.setMinSplitSizeRack(3072L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test7): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)2);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host1.rack1.com");
            file1 = new Path(conf.getWorkingDirectory(), file1);
            file2 = new Path(conf.getWorkingDirectory(), file2);
            file3 = new Path(conf.getWorkingDirectory(), file3);
            file4 = new Path(conf.getWorkingDirectory(), file4);
            inFormat = new DummyInputFormat();
            DummyInputFormat.addInputPath((JobConf)conf, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(conf, new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(TestPool1): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        TestCombineFileInputFormat.writeDataAndSetReplication(fileSys, name, (OutputStream)stm, replication, numBlocks);
    }

    static FileStatus writeGzipFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException, InterruptedException, TimeoutException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        GZIPOutputStream out = new GZIPOutputStream((OutputStream)fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L));
        TestCombineFileInputFormat.writeDataAndSetReplication(fileSys, name, out, replication, numBlocks);
        return fileSys.getFileStatus(name);
    }

    private static void writeDataAndSetReplication(FileSystem fileSys, Path name, OutputStream out, short replication, int numBlocks) throws IOException, InterruptedException, TimeoutException {
        for (int i = 0; i < numBlocks; ++i) {
            out.write(databuf);
        }
        out.close();
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitPlacementForCompressedFiles() throws IOException, InterruptedException, TimeoutException {
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1.gz");
            FileStatus f1 = TestCombineFileInputFormat.writeGzipFile(conf, file1, (short)1, 1);
            Path file5 = new Path(this.dir5 + "/file5.gz");
            FileStatus f5 = TestCombineFileInputFormat.writeGzipFile(conf, file5, (short)1, 1);
            DummyInputFormat inFormat = new DummyInputFormat();
            JobConf job = new JobConf(conf);
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir5));
            InputSplit[] splits = inFormat.getSplits(job, 1);
            System.out.println("Made splits(Test0): " + splits.length);
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)1);
            CombineFileSplit fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file5.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f5.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2.gz");
            FileStatus f2 = TestCombineFileInputFormat.writeGzipFile(conf, file2, (short)2, 2);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits(job, 1);
            System.out.println("Made splits(Test1): " + splits.length);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)2, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3.gz");
            FileStatus f3 = TestCombineFileInputFormat.writeGzipFile(conf, file3, (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(f1.getLen());
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test2): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            Path file4 = new Path(this.dir4 + "/file4.gz");
            FileStatus f4 = TestCombineFileInputFormat.writeGzipFile(conf, file4, (short)3, 3);
            inFormat = new DummyInputFormat();
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(f1.getLen());
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test3): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(f1.getLen());
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test4): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)4, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[3];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(2L * f1.getLen());
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test5): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(2L * f1.getLen());
            inFormat.setMaxSplitSize(4L * f1.getLen());
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test6): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)2, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((float)0.0f, (float)fileSplit.getOffset(1), (float)1024.0f);
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(4L * f1.getLen());
            inFormat.setMinSplitSizeRack(4L * f1.getLen());
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test7): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)4, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(4L * f1.getLen());
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test8): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)4, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat();
            FileInputFormat.addInputPath((JobConf)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(job, new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            for (InputSplit split : splits = inFormat.getSplits(job, 1)) {
                System.out.println("File split(Test9): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.length);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1();
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(job, new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits(job, 1);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools " + " and " + numFiles + " files is " + (end - start) + " milli seconds.");
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingBlocks() throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        String testName = "testMissingBlocks";
        try {
            Configuration conf = new Configuration();
            conf.set("fs.hdfs.impl", MissingBlockFileSystem.class.getName());
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile(conf, file1, (short)1, 1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile(conf, file5, (short)1, 1);
            ((MissingBlockFileSystem)fileSys).setFileWithMissingBlocks(file1.toUri().getPath());
            DummyInputFormat inFormat = new DummyInputFormat();
            JobConf job = new JobConf(conf);
            FileInputFormat.setInputPaths((JobConf)job, (String)(this.dir1 + "," + this.dir5));
            InputSplit[] splits = inFormat.getSplits(job, 7);
            System.out.println("Made splits(Test0): " + splits.length);
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.length);
            CombineFileSplit fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file5.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat();
        JobConf job = new JobConf(conf);
        FileInputFormat.setInputPaths((JobConf)job, (String)"test");
        InputSplit[] splits = inFormat.getSplits(job, 7);
        TestCombineFileInputFormat.assertEquals((int)1, (int)splits.length);
        CombineFileSplit fileSplit = (CombineFileSplit)splits[0];
        TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
        TestCombineFileInputFormat.assertEquals((String)file.getName(), (String)fileSplit.getPath(0).getName());
        TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
        TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getLength(0));
        fileSys.delete(file.getParent(), true);
    }

    public void testForNonDefaultFileSystem() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", DUMMY_FS_URI);
        TestCombineFileInputFormat.assertEquals((String)DUMMY_FS_URI, (String)FileSystem.getDefaultUri((Configuration)conf).toString());
        Path localPath = new Path("testFile1");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream dos = lfs.create(localPath);
        dos.writeChars("Local file for CFIF");
        dos.close();
        conf.set("mapred.working.dir", "/");
        JobConf job = new JobConf(conf);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{lfs.makeQualified(localPath)});
        DummyInputFormat inFormat = new DummyInputFormat();
        InputSplit[] splits = inFormat.getSplits(job, 1);
        TestCombineFileInputFormat.assertTrue((splits.length > 0 ? 1 : 0) != 0);
        for (InputSplit s : splits) {
            CombineFileSplit cfs = (CombineFileSplit)s;
            for (Path p : cfs.getPaths()) {
                TestCombineFileInputFormat.assertEquals((String)p.toUri().getScheme(), (String)"file");
            }
        }
    }

    public void testGetConfiguredMaxSplitSize() throws Throwable {
        JobConf conf = new JobConf();
        DummyInputFormat inFormat = new DummyInputFormat();
        long maxSize = inFormat.getConfiguredMaxSplitSize(conf);
        TestCombineFileInputFormat.assertEquals((long)maxSize, (long)0L);
        conf.setLong("mapreduce.input.fileinputformat.split.maxsize", 100L);
        maxSize = inFormat.getConfiguredMaxSplitSize(conf);
        TestCombineFileInputFormat.assertEquals((long)maxSize, (long)100L);
        conf.setLong("mapred.max.split.size", 1000L);
        maxSize = inFormat.getConfiguredMaxSplitSize(conf);
        TestCombineFileInputFormat.assertEquals((long)maxSize, (long)1000L);
    }

    private void splitRealFiles(String[] args) throws IOException {
        JobConf conf = new JobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException("Wrong file system: " + fs.getClass().getName());
        }
        int blockSize = conf.getInt("dfs.block.size", 0x8000000);
        DummyInputFormat inFormat = new DummyInputFormat();
        for (int i = 0; i < args.length; ++i) {
            DummyInputFormat.addInputPaths((JobConf)conf, (String)args[i]);
        }
        inFormat.setMinSplitSizeRack(blockSize);
        inFormat.setMaxSplitSize(10 * blockSize);
        InputSplit[] splits = inFormat.getSplits(conf, 1);
        System.out.println("Total number of splits " + splits.length);
        for (int i = 0; i < splits.length; ++i) {
            CombineFileSplit fileSplit = (CombineFileSplit)splits[i];
            System.out.println("Split[" + i + "] " + fileSplit);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.splitRealFiles(args);
        } else {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.testSplitPlacement();
        }
    }

    static class TestFilter
    implements PathFilter {
        private Path p;

        public TestFilter(Path p) {
            this.p = p;
        }

        public boolean accept(Path path) {
            return path.toUri().getPath().indexOf(this.p.toString()) == 0;
        }

        public String toString() {
            return "PathFilter:" + this.p;
        }
    }

    public static class MissingBlockFileSystem
    extends DistributedFileSystem {
        String fileWithMissingBlocks;

        public void initialize(URI name, Configuration conf) throws IOException {
            this.fileWithMissingBlocks = "";
            super.initialize(name, conf);
        }

        public BlockLocation[] getFileBlockLocations(FileStatus stat, long start, long len) throws IOException {
            if (stat.isDir()) {
                return null;
            }
            System.out.println("File " + stat.getPath());
            String name = stat.getPath().toUri().getPath();
            BlockLocation[] locs = super.getFileBlockLocations(stat, start, len);
            if (name.equals(this.fileWithMissingBlocks)) {
                System.out.println("Returning missing blocks for " + this.fileWithMissingBlocks);
                locs[0] = new HdfsBlockLocation(new BlockLocation(new String[0], new String[0], locs[0].getOffset(), locs[0].getLength()), null);
            }
            return locs;
        }

        public void setFileWithMissingBlocks(String f) {
            this.fileWithMissingBlocks = f;
        }
    }

    private class DummyInputFormat1
    extends DummyInputFormat {
        private DummyInputFormat1() {
        }

        protected FileStatus[] listStatus(JobConf job) throws IOException {
            Path[] files = DummyInputFormat1.getInputPaths((JobConf)job);
            FileStatus[] results = new FileStatus[files.length];
            for (int i = 0; i < files.length; ++i) {
                Path p = files[i];
                FileSystem fs = p.getFileSystem((Configuration)job);
                results[i] = fs.getFileStatus(p);
            }
            return results;
        }
    }

    private class DummyInputFormat
    extends CombineFileInputFormat<Text, Text> {
        private DummyInputFormat() {
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return null;
        }
    }
}

