/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskTrackerDirectories {
    private final String TEST_DIR = new File("build/test/testmapredlocaldir").getAbsolutePath();

    @Before
    public void deleteTestDir() throws IOException {
        FileUtil.fullyDelete((File)new File(this.TEST_DIR));
        Assert.assertFalse((String)("Could not delete " + this.TEST_DIR), (boolean)new File(this.TEST_DIR).exists());
    }

    @Test
    public void testCreatesLocalDirs() throws Exception {
        Configuration conf = new Configuration();
        String[] dirs = new String[]{this.TEST_DIR + "/local1", this.TEST_DIR + "/local2"};
        conf.setStrings("mapred.local.dir", dirs);
        this.setupTaskTracker(conf);
        for (String dir : dirs) {
            this.checkDir(dir);
        }
    }

    @Test
    public void testFixesLocalDirPermissions() throws Exception {
        Configuration conf = new Configuration();
        String[] dirs = new String[]{this.TEST_DIR + "/badperms"};
        new File(dirs[0]).mkdirs();
        FileUtil.chmod((String)dirs[0], (String)"000");
        conf.setStrings("mapred.local.dir", dirs);
        this.setupTaskTracker(conf);
        for (String dir : dirs) {
            this.checkDir(dir);
        }
    }

    @Test
    public void testCreatesAndDeletesRequiredDirs() throws Exception {
        String[] dirs = new String[]{this.TEST_DIR + "/local1", this.TEST_DIR + "/local2"};
        Configuration conf = new Configuration();
        conf.setStrings("mapred.local.dir", dirs);
        TaskTracker tt = this.setupTaskTracker(conf);
        for (String dir : TaskTracker.dirsToCleanup) {
            this.checkDirExists(new Path(dirs[0], dir));
            this.checkDirExists(new Path(dirs[1], dir));
        }
        try {
            tt.shutdown();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        for (String dir : TaskTracker.dirsToCleanup) {
            this.checkDirDoesNotExist(new Path(dirs[0], dir));
            this.checkDirDoesNotExist(new Path(dirs[1], dir));
        }
    }

    @Test
    public void testCreatesLogDirs() throws Exception {
        String[] dirs = new String[]{this.TEST_DIR + "/local1", this.TEST_DIR + "/local2"};
        Path logDir1 = new Path(dirs[0], "userlogs");
        Path logDir2 = new Path(dirs[1], "userlogs");
        FileUtil.fullyDelete((File)new File(logDir1.toString()));
        FileUtil.fullyDelete((File)new File(logDir2.toString()));
        Configuration conf = new Configuration();
        conf.setStrings("mapred.local.dir", dirs);
        this.setupTaskTracker(conf);
        this.checkDir(logDir1.toString());
        this.checkDir(logDir2.toString());
    }

    @Test
    public void testFixesLogDirPermissions() throws Exception {
        String[] dirs = new String[]{this.TEST_DIR + "/local1"};
        File dir = new File(dirs[0]);
        FileUtil.fullyDelete((File)dir);
        dir.mkdirs();
        FileUtil.chmod((String)dir.getAbsolutePath(), (String)"000");
        Configuration conf = new Configuration();
        conf.setStrings("mapred.local.dir", dirs);
        this.setupTaskTracker(conf);
        this.checkDir(dir.getAbsolutePath());
    }

    private TaskTracker setupTaskTracker(Configuration conf) throws Exception {
        JobConf ttConf = new JobConf(conf);
        TaskTracker tt = new TaskTracker();
        tt.setConf(ttConf);
        tt.setTaskController((TaskController)Mockito.mock(TaskController.class));
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("mapred.local.dir");
        tt.setLocalDirAllocator(localDirAllocator);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        TaskTracker.LocalStorage localStorage = new TaskTracker.LocalStorage(ttConf.getLocalDirs());
        localStorage.checkDirs(localFs, true);
        tt.setLocalStorage(localStorage);
        tt.setLocalFileSystem((FileSystem)localFs);
        tt.initializeDirectories();
        return tt;
    }

    private void checkDir(String dir) throws IOException {
        FileSystem fs = RawLocalFileSystem.get((Configuration)new Configuration());
        File f = new File(dir);
        Assert.assertTrue((String)(dir + " should exist"), (boolean)f.exists());
        FileStatus stat = fs.getFileStatus(new Path(dir));
        Assert.assertEquals((String)(dir + " has correct permissions"), (long)493L, (long)stat.getPermission().toShort());
    }

    private void checkDirExists(Path path) throws IOException {
        File f = new File(path.toString());
        Assert.assertTrue((String)(path + " should exist"), (boolean)f.exists());
    }

    private void checkDirDoesNotExist(Path path) throws IOException {
        File f = new File(path.toString());
        Assert.assertFalse((String)(path + " should not exist"), (boolean)f.exists());
    }
}

