/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.junit.Test;

public class TestTaskStatus
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestTaskStatus.class);

    public void testMapTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(true);
    }

    public void testReduceTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(false);
    }

    private void checkTaskStatues(boolean isMap) {
        Object status = null;
        status = isMap ? new MapTaskStatus() : new ReduceTaskStatus();
        long currentTime = System.currentTimeMillis();
        status.setFinishTime(currentTime);
        TestTaskStatus.assertEquals((String)"Finish time of the task status set without start time", (long)0L, (long)status.getFinishTime());
        status.setStartTime(currentTime);
        TestTaskStatus.assertEquals((String)"Start time of the task status not set correctly.", (long)currentTime, (long)status.getStartTime());
        long wrongTime = -1L;
        status.setStartTime(wrongTime);
        TestTaskStatus.assertEquals((String)"Start time of the task status is set to wrong negative value", (long)currentTime, (long)status.getStartTime());
        status.setFinishTime(wrongTime);
        TestTaskStatus.assertEquals((String)"Finish time of task status is set to wrong negative value", (long)0L, (long)status.getFinishTime());
        status.setFinishTime(currentTime);
        TestTaskStatus.assertEquals((String)"Finish time of the task status not set correctly.", (long)currentTime, (long)status.getFinishTime());
        TaskStatus ts = (TaskStatus)status.clone();
        ts.setDiagnosticInfo(null);
        ts.setDiagnosticInfo("");
        ts.setStateString(null);
        ts.setStateString("");
        ((TaskStatus)status.clone()).statusUpdate(ts);
        ((TaskStatus)status.clone()).statusUpdate(0.0f, null, null);
        ((TaskStatus)status.clone()).statusUpdate(0.0f, "", null);
        ((TaskStatus)status.clone()).statusUpdate(null, 0.0f, "", null, 1L);
    }

    @Test
    public void testTaskDiagnosticsAndStateString() {
        String test = "hi";
        int maxSize = 16;
        TaskStatus status = new TaskStatus(null, 0.0f, 0, null, test, test, null, null, null){

            protected int getMaxStringSize() {
                return 16;
            }

            public void addFetchFailedMap(TaskAttemptID mapTaskId) {
            }

            public boolean getIsMap() {
                return false;
            }
        };
        TestTaskStatus.assertEquals((String)"Small diagnostic info test failed", (String)status.getDiagnosticInfo(), (String)test);
        TestTaskStatus.assertEquals((String)"Small state string test failed", (String)status.getStateString(), (String)test);
        String newDInfo = test.concat(test);
        status.setDiagnosticInfo(test);
        status.setStateString(newDInfo);
        TestTaskStatus.assertEquals((String)"Small diagnostic info append failed", (String)newDInfo, (String)status.getDiagnosticInfo());
        TestTaskStatus.assertEquals((String)"Small state-string append failed", (String)newDInfo, (String)status.getStateString());
        TaskStatus newStatus = (TaskStatus)status.clone();
        String newSInfo = "hi1";
        newStatus.setStateString(newSInfo);
        status.statusUpdate(newStatus);
        newDInfo = newDInfo.concat(newStatus.getDiagnosticInfo());
        TestTaskStatus.assertEquals((String)"Status-update on diagnostic-info failed", (String)newDInfo, (String)status.getDiagnosticInfo());
        TestTaskStatus.assertEquals((String)"Status-update on state-string failed", (String)newSInfo, (String)status.getStateString());
        newSInfo = "hi2";
        status.statusUpdate(0.0f, newSInfo, null);
        TestTaskStatus.assertEquals((String)"Status-update on state-string failed", (String)newSInfo, (String)status.getStateString());
        newSInfo = "hi3";
        status.statusUpdate(null, 0.0f, newSInfo, null, 0L);
        TestTaskStatus.assertEquals((String)"Status-update on state-string failed", (String)newSInfo, (String)status.getStateString());
        String large = "hihihihihihihihihihi";
        status.setDiagnosticInfo(large);
        status.setStateString(large);
        TestTaskStatus.assertEquals((String)"Large diagnostic info append test failed", (int)16, (int)status.getDiagnosticInfo().length());
        TestTaskStatus.assertEquals((String)"Large state-string append test failed", (int)16, (int)status.getStateString().length());
        newStatus.setDiagnosticInfo(large + "0");
        newStatus.setStateString(large + "1");
        status.statusUpdate(newStatus);
        TestTaskStatus.assertEquals((String)"Status-update on diagnostic info failed", (int)16, (int)status.getDiagnosticInfo().length());
        TestTaskStatus.assertEquals((String)"Status-update on state-string failed", (int)16, (int)status.getStateString().length());
        status.statusUpdate(0.0f, large + "2", null);
        TestTaskStatus.assertEquals((String)"Status-update on state-string failed", (int)16, (int)status.getStateString().length());
        status.statusUpdate(null, 0.0f, large + "3", null, 0L);
        TestTaskStatus.assertEquals((String)"Status-update on state-string failed", (int)16, (int)status.getStateString().length());
        status = new TaskStatus(null, 0.0f, 0, null, large, large, null, null, null){

            protected int getMaxStringSize() {
                return 16;
            }

            public void addFetchFailedMap(TaskAttemptID mapTaskId) {
            }

            public boolean getIsMap() {
                return false;
            }
        };
        TestTaskStatus.assertEquals((String)"Large diagnostic info test failed", (int)16, (int)status.getDiagnosticInfo().length());
        TestTaskStatus.assertEquals((String)"Large state-string test failed", (int)16, (int)status.getStateString().length());
    }
}

