/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ResourceEstimator;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.split.JobSplit;

public class TestResourceEstimation
extends TestCase {
    public void testResourceEstimator() throws Exception {
        int maps = 100;
        int reduces = 2;
        int singleMapOutputSize = 1000;
        JobConf jc = new JobConf();
        JobID jid = new JobID("testJT", 0);
        jc.setNumMapTasks(100);
        jc.setNumReduceTasks(2);
        JobInProgress jip = new JobInProgress(jid, jc, UtilsForTests.getJobTracker());
        ResourceEstimator re = new ResourceEstimator(jip);
        for (int i = 0; i < 100; ++i) {
            if (i < 10) {
                long estOutSize = re.getEstimatedMapOutputSize();
                System.out.println(estOutSize);
                TestResourceEstimation.assertEquals((long)0L, (long)estOutSize);
            }
            MapTaskStatus ts = new MapTaskStatus();
            ts.setOutputSize(1000L);
            JobSplit.TaskSplitMetaInfo split = new JobSplit.TaskSplitMetaInfo(new String[0], 0L, 0L);
            TaskInProgress tip = new TaskInProgress(jid, "", split, jip.jobtracker, jc, jip, 0, 1);
            re.updateWithCompletedTask((TaskStatus)ts, tip);
        }
        TestResourceEstimation.assertEquals((long)2000L, (long)re.getEstimatedMapOutputSize());
        TestResourceEstimation.assertEquals((long)100000L, (long)re.getEstimatedReduceInputSize());
    }

    public void testWithNonZeroInput() throws Exception {
        int maps = 100;
        int reduces = 2;
        int singleMapOutputSize = 1000;
        int singleMapInputSize = 500;
        JobConf jc = new JobConf();
        JobID jid = new JobID("testJT", 0);
        jc.setNumMapTasks(100);
        jc.setNumReduceTasks(2);
        JobInProgress jip = new JobInProgress(jid, jc, UtilsForTests.getJobTracker()){

            long getInputLength() {
                return 500 * this.desiredMaps();
            }
        };
        ResourceEstimator re = new ResourceEstimator(jip);
        for (int i = 0; i < 10; ++i) {
            long estOutSize = re.getEstimatedMapOutputSize();
            System.out.println(estOutSize);
            TestResourceEstimation.assertEquals((long)0L, (long)estOutSize);
            MapTaskStatus ts = new MapTaskStatus();
            ts.setOutputSize(1000L);
            JobSplit.TaskSplitMetaInfo split = new JobSplit.TaskSplitMetaInfo(new String[0], 0L, 500L);
            TaskInProgress tip = new TaskInProgress(jid, "", split, jip.jobtracker, jc, jip, 0, 1);
            re.updateWithCompletedTask((TaskStatus)ts, tip);
        }
        TestResourceEstimation.assertEquals((long)2000L, (long)re.getEstimatedMapOutputSize());
        TestResourceEstimation.assertEquals((long)100000L, (long)re.getEstimatedReduceInputSize());
        MapTaskStatus ts = new MapTaskStatus();
        ts.setOutputSize(1000L);
        JobSplit.TaskSplitMetaInfo split = new JobSplit.TaskSplitMetaInfo(new String[0], 0L, 0L);
        TaskInProgress tip = new TaskInProgress(jid, "", split, jip.jobtracker, jc, jip, 0, 1);
        re.updateWithCompletedTask((TaskStatus)ts, tip);
        long expectedTotalMapOutSize = 91681L;
        TestResourceEstimation.assertEquals((long)(2L * expectedTotalMapOutSize / 100L), (long)re.getEstimatedMapOutputSize());
    }
}

