/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestReduceTaskFetchFail {
    @Test
    public void testcheckAndInformJobTracker() throws Exception {
        TaskUmbilicalProtocol mockUmbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Task.TaskReporter mockTaskReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        JobConf conf = new JobConf();
        conf.setUser("testuser");
        conf.setJobName("testJob");
        conf.setSessionId("testSession");
        TaskAttemptID tid = new TaskAttemptID();
        TestReduceTask rTask = new TestReduceTask();
        rTask.setConf((Configuration)conf);
        ShuffleConsumerPlugin.Context context = new ShuffleConsumerPlugin.Context(mockUmbilical, conf, mockTaskReporter, (ReduceTask)rTask);
        TestReduceTask.TestShuffleConsumer reduceCopier = rTask.new TestReduceTask.TestShuffleConsumer();
        reduceCopier.init(context);
        reduceCopier.checkAndInformJobTracker(1, tid, false);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        reduceCopier.checkAndInformJobTracker(10, tid, false);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)1))).progress();
        conf.setInt("mapreduce.reduce.shuffle.maxfetchfailures", 3);
        rTask.setConf((Configuration)conf);
        context = new ShuffleConsumerPlugin.Context(mockUmbilical, conf, mockTaskReporter, (ReduceTask)rTask);
        reduceCopier = rTask.new TestReduceTask.TestShuffleConsumer();
        reduceCopier.init(context);
        reduceCopier.checkAndInformJobTracker(1, tid, false);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)1))).progress();
        reduceCopier.checkAndInformJobTracker(3, tid, false);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)2))).progress();
        reduceCopier.checkAndInformJobTracker(5, tid, false);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)2))).progress();
        reduceCopier.checkAndInformJobTracker(6, tid, false);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)3))).progress();
        reduceCopier.checkAndInformJobTracker(7, tid, true);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)4))).progress();
        conf.setBoolean("mapreduce.reduce.shuffle.notify.readerror", false);
        rTask.setConf((Configuration)conf);
        context = new ShuffleConsumerPlugin.Context(mockUmbilical, conf, mockTaskReporter, (ReduceTask)rTask);
        reduceCopier = rTask.new TestReduceTask.TestShuffleConsumer();
        reduceCopier.init(context);
        reduceCopier.checkAndInformJobTracker(7, tid, true);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)4))).progress();
    }

    public static class TestReduceTask
    extends ReduceTask {
        public String getJobFile() {
            return "/foo";
        }

        public class TestShuffleConsumer
        extends ReduceTask.ReduceCopier {
            public void init(ShuffleConsumerPlugin.Context context) throws ClassNotFoundException, IOException {
                super.init(context);
            }

            public void checkAndInformJobTracker(int failures, TaskAttemptID mapId, boolean readError) {
                super.checkAndInformJobTracker(failures, mapId, readError);
            }
        }
    }
}

