/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalModeWithNewApis {
    public static final Log LOG = LogFactory.getLog(TestLocalModeWithNewApis.class);
    Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testNewApis() throws Exception {
        Random r = new Random(System.currentTimeMillis());
        Path tmpBaseDir = new Path("/tmp/wc-" + r.nextInt());
        Path inDir = new Path(tmpBaseDir, "input");
        Path outDir = new Path(tmpBaseDir, "output");
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        FileSystem inFs = inDir.getFileSystem(this.conf);
        FileSystem outFs = outDir.getFileSystem(this.conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        Job job = new Job(this.conf, "word count");
        job.setJarByClass(TestLocalModeWithNewApis.class);
        job.setMapperClass(TokenizerMapper.class);
        job.setCombinerClass(IntSumReducer.class);
        job.setReducerClass(IntSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)inDir);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Assert.assertEquals((Object)job.waitForCompletion(true), (Object)true);
        String output = TestLocalModeWithNewApis.readOutput(outDir, this.conf);
        Assert.assertEquals((Object)"The\t1\nbrown\t1\nfox\t2\nhas\t1\nmany\t1\nquick\t1\nred\t1\nsilly\t1\nsox\t1\n", (Object)output);
        outFs.delete(tmpBaseDir, true);
    }

    static String readOutput(Path outDir, Configuration conf) throws IOException {
        Path[] fileList;
        FileSystem fs = outDir.getFileSystem(conf);
        StringBuffer result = new StringBuffer();
        for (Path outputFile : fileList = FileUtil.stat2Paths((FileStatus[])fs.listStatus(outDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))) {
            LOG.info((Object)("Path: " + outputFile));
            BufferedReader file = new BufferedReader(new InputStreamReader((InputStream)fs.open(outputFile)));
            String line = file.readLine();
            while (line != null) {
                result.append(line);
                result.append("\n");
                line = file.readLine();
            }
            file.close();
        }
        return result.toString();
    }

    public static class IntSumReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    public static class TokenizerMapper
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)one);
            }
        }
    }
}

