/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.tools.ant.util.FileUtils;
import org.junit.Test;

public class TestLineRecordReader
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestLineRecordReader.class.getName());
    private static Path workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestTextInputFormat");
    private static Path inputDir = new Path(workDir, "input");
    private static Path outputDir = new Path(workDir, "output");

    public void createInputFile(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(inputDir, "test.txt");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
        writer.write("abc\ndef\t\nghi\njkl");
        ((Writer)writer).close();
    }

    public String readOutputFile(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(outputDir, "part-00000");
        InputStreamReader reader = new InputStreamReader((InputStream)localFs.open(file));
        String r = FileUtils.readFully((Reader)reader);
        ((Reader)reader).close();
        return r;
    }

    public void createAndRunJob(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf job = new JobConf(conf);
        job.setJarByClass(TestLineRecordReader.class);
        job.setMapperClass(IdentityMapper.class);
        job.setReducerClass(IdentityReducer.class);
        FileInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        JobClient.runJob((JobConf)job);
    }

    @Test
    public void testCustomRecordDelimiters() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("textinputformat.record.delimiter", "\t\n");
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(workDir, true);
        this.createInputFile(conf);
        this.createAndRunJob(conf);
        String expected = "0\tabc\ndef\n9\tghi\njkl\n";
        TestLineRecordReader.assertEquals((String)expected, (String)this.readOutputFile(conf));
    }

    @Test
    public void testDefaultRecordDelimiters() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(workDir, true);
        this.createInputFile(conf);
        this.createAndRunJob(conf);
        String expected = "0\tabc\n4\tdef\t\n9\tghi\n13\tjkl\n";
        TestLineRecordReader.assertEquals((String)expected, (String)this.readOutputFile(conf));
    }

    @Test
    public void testStripBOM() throws IOException {
        LOG.info((Object)"testStripBOM");
        Path localCachePath = new Path(System.getProperty("test.cache.data"));
        Path txtPath = new Path(localCachePath, new Path("testBOM.txt"));
        String UTF8_BOM = "\ufeff";
        LOG.info((Object)txtPath.toString());
        File testFile = new File(txtPath.toString());
        long testFileSize = testFile.length();
        Configuration conf = new Configuration();
        conf.setInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(txtPath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int numRecords = 0;
        boolean firstLine = true;
        boolean skipBOM = true;
        String prevVal = null;
        while (reader.next(key, value)) {
            if (firstLine) {
                firstLine = false;
                if (value.toString().startsWith(UTF8_BOM)) {
                    skipBOM = false;
                }
            } else {
                TestLineRecordReader.assertEquals((String)"not same text", prevVal, (String)value.toString());
            }
            prevVal = new String(value.toString());
            ++numRecords;
        }
        reader.close();
        TestLineRecordReader.assertTrue((String)"BOM is not skipped", (boolean)skipBOM);
    }

    private void testSplitRecords(String testFileName, long firstSplitLength) throws IOException {
        Path localCachePath = new Path(System.getProperty("test.cache.data"));
        Path txtPath = new Path(localCachePath, new Path(testFileName));
        File testFile = new File(txtPath.toString());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Configuration conf = new Configuration();
        this.testSplitRecordsForFile(conf, firstSplitLength, testFileSize, testFilePath);
    }

    private void testSplitRecordsForFile(Configuration conf, long firstSplitLength, long testFileSize, Path testFilePath) throws IOException {
        conf.setInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        TestLineRecordReader.assertTrue((String)("unexpected test data at " + testFilePath), (testFileSize > firstSplitLength ? 1 : 0) != 0);
        String delimiter = conf.get("textinputformat.record.delimiter");
        byte[] recordDelimiterBytes = null;
        if (null != delimiter) {
            recordDelimiterBytes = delimiter.getBytes(Charsets.UTF_8);
        }
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int numRecordsNoSplits = 0;
        while (reader.next(key, value)) {
            ++numRecordsNoSplits;
        }
        reader.close();
        split = new FileSplit(testFilePath, 0L, firstSplitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        int numRecordsFirstSplit = 0;
        while (reader.next(key, value)) {
            ++numRecordsFirstSplit;
        }
        reader.close();
        split = new FileSplit(testFilePath, firstSplitLength, testFileSize - firstSplitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        int numRecordsRemainingSplits = 0;
        while (reader.next(key, value)) {
            ++numRecordsRemainingSplits;
        }
        reader.close();
        TestLineRecordReader.assertEquals((String)"Unexpected number of records in split", (int)numRecordsNoSplits, (int)(numRecordsFirstSplit + numRecordsRemainingSplits));
    }

    @Test
    public void testBzip2SplitEndsAtCR() throws IOException {
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136498L);
    }

    @Test
    public void testBzip2SplitEndsAtCRThenLF() throws IOException {
        this.testSplitRecords("blockEndingInCRThenLF.txt.bz2", 136498L);
    }

    @Test
    public void testBzip2SplitStartAtBlockMarker() throws IOException {
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136504L);
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136505L);
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136508L);
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136494L);
    }

    @Test
    public void testMultipleClose() throws IOException {
        Path localCachePath = new Path(System.getProperty("test.cache.data"));
        Path txtPath = new Path(localCachePath, new Path("blockEndingInCR.txt.bz2"));
        File testFile = new File(txtPath.toString());
        Path testFilePath = new Path(testFile.getAbsolutePath());
        long testFileSize = testFile.length();
        Configuration conf = new Configuration();
        conf.setInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split);
        LongWritable key = new LongWritable();
        Text value = new Text();
        while (reader.next(key, value)) {
        }
        reader.close();
        reader.close();
        BZip2Codec codec = new BZip2Codec();
        codec.setConf(conf);
        HashSet<Decompressor> decompressors = new HashSet<Decompressor>();
        for (int i = 0; i < 10; ++i) {
            decompressors.add(CodecPool.getDecompressor((CompressionCodec)codec));
        }
        TestLineRecordReader.assertEquals((int)10, (int)decompressors.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path createInputFile(Configuration conf, String data) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(inputDir, "test.txt");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
            writer.write(data);
        }
        return file;
    }

    @Test
    public void testUncompressedInput() throws Exception {
        int splitSize;
        int bufferSize;
        Configuration conf = new Configuration();
        String inputData = "abc+def+ghi+jkl+mno+pqr+stu+vw +xyz";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc|+|def|+|ghi|+|jkl|+|mno|+|pqr|+|stu|+|vw |+|xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "|+|");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc+def++ghi+jkl++mno+pqr++stu+vw ++xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc|+||+|defghi|+|jkl|+||+|mno|+|pqr|+||+|stu|+|vw |+||+|xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "|+|");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc+def+-ghi+jkl+-mno+pqr+-stu+vw +-xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+-");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc\n+def\n+ghi\n+jkl\n+mno";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "\n+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc\ndef+\nghi+\njkl\nmno";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+\n");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
    }

    @Test
    public void testUncompressedInputContainingCRLF() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "a\r\nb\rc\nd\r\n";
        Path inputFile = this.createInputFile(conf, inputData);
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (int splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
    }

    @Test
    public void testUncompressedInputCustomDelimiterPosValue() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 10);
        conf.setInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        String inputData = "abcdefghij++kl++mno";
        Path inputFile = this.createInputFile(conf, inputData);
        String delimiter = "++";
        byte[] recordDelimiterBytes = delimiter.getBytes(Charsets.UTF_8);
        int splitLength = 15;
        FileSplit split = new FileSplit(inputFile, 0L, (long)splitLength, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        LongWritable key = new LongWritable();
        Text value = new Text();
        TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong length for record value", (int)10, (int)value.getLength());
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)12L, (long)reader.getPos());
        TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong length for record value", (int)2, (int)value.getLength());
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)16L, (long)reader.getPos());
        TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong length for record value", (int)3, (int)value.getLength());
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        TestLineRecordReader.assertFalse((boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        reader.close();
        split = new FileSplit(inputFile, (long)splitLength, (long)(inputData.length() - splitLength), (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        TestLineRecordReader.assertFalse((String)"Unexpected record returned", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        reader.close();
        inputData = "abcd+efgh++ijk++mno";
        inputFile = this.createInputFile(conf, inputData);
        splitLength = 5;
        split = new FileSplit(inputFile, 0L, (long)splitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)11L, (long)reader.getPos());
        TestLineRecordReader.assertEquals((String)"Wrong length for record value", (int)9, (int)value.getLength());
        TestLineRecordReader.assertFalse((String)"Unexpected record returned", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)11L, (long)reader.getPos());
        reader.close();
        split = new FileSplit(inputFile, (long)splitLength, (long)(inputData.length() - splitLength), (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)16L, (long)reader.getPos());
        TestLineRecordReader.assertEquals((String)"Wrong length for record value", (int)3, (int)value.getLength());
        TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        TestLineRecordReader.assertEquals((String)"Wrong length for record value", (int)3, (int)value.getLength());
        TestLineRecordReader.assertFalse((boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        reader.close();
        inputData = "abcd|efgh|+|ij|kl|+|mno|pqr";
        inputFile = this.createInputFile(conf, inputData);
        delimiter = "|+|";
        recordDelimiterBytes = delimiter.getBytes(Charsets.UTF_8);
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (int splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                split = new FileSplit(inputFile, 0L, (long)bufferSize, (String[])null);
                reader = new LineRecordReader(conf, split, recordDelimiterBytes);
                TestLineRecordReader.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
                TestLineRecordReader.assertTrue((boolean)"abcd|efgh".equals(value.toString()));
                TestLineRecordReader.assertEquals((String)"Wrong position after record read", (int)9, (int)value.getLength());
                int recordPos = 12;
                TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                if (reader.next(key, value)) {
                    TestLineRecordReader.assertTrue((boolean)"ij|kl".equals(value.toString()));
                    recordPos = 20;
                    TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                }
                if (reader.next(key, value)) {
                    TestLineRecordReader.assertTrue((boolean)"mno|pqr".equals(value.toString()));
                    recordPos = inputData.length();
                    TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                }
                TestLineRecordReader.assertFalse((String)"Unexpected record returned", (boolean)reader.next(key, value));
                TestLineRecordReader.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                reader.close();
            }
        }
    }

    @Test
    public void testUncompressedInputDefaultDelimiterPosValue() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "1234567890\r\n12\r\n345";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.setInt("io.file.buffer.size", 10);
        conf.setInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(inputFile, 0L, 15L, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, null);
        LongWritable key = new LongWritable();
        Text value = new Text();
        reader.next(key, value);
        TestLineRecordReader.assertEquals((int)10, (int)value.getLength());
        TestLineRecordReader.assertEquals((long)12L, (long)reader.getPos());
        reader.next(key, value);
        TestLineRecordReader.assertEquals((int)2, (int)value.getLength());
        TestLineRecordReader.assertEquals((long)16L, (long)reader.getPos());
        TestLineRecordReader.assertFalse((boolean)reader.next(key, value));
        split = new FileSplit(inputFile, 15L, 4L, (String[])null);
        reader = new LineRecordReader(conf, split, null);
        TestLineRecordReader.assertEquals((long)16L, (long)reader.getPos());
        reader.next(key, value);
        TestLineRecordReader.assertEquals((int)3, (int)value.getLength());
        TestLineRecordReader.assertEquals((long)19L, (long)reader.getPos());
        TestLineRecordReader.assertFalse((boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((long)19L, (long)reader.getPos());
        inputData = "123456789\r\r\n";
        inputFile = this.createInputFile(conf, inputData);
        split = new FileSplit(inputFile, 0L, 12L, (String[])null);
        reader = new LineRecordReader(conf, split, null);
        reader.next(key, value);
        TestLineRecordReader.assertEquals((int)9, (int)value.getLength());
        TestLineRecordReader.assertEquals((long)10L, (long)reader.getPos());
        reader.next(key, value);
        TestLineRecordReader.assertEquals((int)0, (int)value.getLength());
        TestLineRecordReader.assertEquals((long)12L, (long)reader.getPos());
        TestLineRecordReader.assertFalse((boolean)reader.next(key, value));
        TestLineRecordReader.assertEquals((long)12L, (long)reader.getPos());
    }
}

