/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.TestNodeFencer;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobTrackerHADaemon;
import org.apache.hadoop.mapred.JobTrackerHAHttpRedirector;
import org.apache.hadoop.mapred.JobTrackerHAServiceTarget;
import org.apache.hadoop.mapred.MiniMRHACluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;

public class TestHAWebUI {
    private static final Log LOG = LogFactory.getLog(TestHAWebUI.class);
    private MiniMRHACluster cluster;
    private JobTrackerHADaemon jt1;
    private JobTrackerHADaemon jt2;
    private JobTrackerHAServiceTarget target1;
    private JobTrackerHAServiceTarget target2;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("mapred.ha.fencing.methods", TestNodeFencer.AlwaysSucceedFencer.class.getName());
        this.cluster = new MiniMRHACluster(this.conf);
        this.cluster.getJobTrackerHaDaemon(0).makeActive();
        this.cluster.startTaskTracker(0, 1);
        this.cluster.waitActive();
        this.jt1 = this.cluster.getJobTrackerHaDaemon(0);
        this.jt2 = this.cluster.getJobTrackerHaDaemon(1);
        this.target1 = new JobTrackerHAServiceTarget(this.jt1.getConf());
        this.target2 = new JobTrackerHAServiceTarget(this.jt2.getConf());
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    @Test(timeout=60000L)
    public void testRedirect() throws Exception {
        this.checkJobTrackerPage("jt1");
        this.checkJobTrackerPage("jt2");
        FailoverController fc = new FailoverController(this.conf, HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        fc.failover((HAServiceTarget)this.target1, (HAServiceTarget)this.target2, false, false);
        this.cluster.waitActive();
        this.checkJobTrackerPage("jt1");
        this.checkJobTrackerPage("jt2");
    }

    private void checkJobTrackerPage(String jtId) throws IOException {
        String redirectAddress = this.conf.get(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.http-redirect-address", (String[])new String[]{"logicaljt", jtId}));
        URL url = new URL("http://" + redirectAddress + "/jobtracker.jsp");
        String page = DFSTestUtil.urlGet((URL)url);
        Assert.assertTrue((boolean)page.contains("Hadoop Map/Reduce Administration"));
    }

    private Server createJettyServer() throws Exception {
        InetAddress localhost = InetAddress.getByName("localhost");
        String host = "localhost";
        ServerSocket ss = new ServerSocket(0, 50, localhost);
        int port = ss.getLocalPort();
        ss.close();
        Server server = new Server(0);
        server.getConnectors()[0].setHost(host);
        server.getConnectors()[0].setPort(port);
        return server;
    }

    private URL getJettyURL(Server server) throws Exception {
        if (server == null) {
            throw new IllegalStateException("This test does not use @TestJetty");
        }
        return new URL("http://" + server.getConnectors()[0].getHost() + ":" + server.getConnectors()[0].getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRedirect(Class firstServletClass, Class secondServlet, int expectedResponse) throws Exception {
        Server server1 = null;
        Server server2 = null;
        try {
            server1 = this.createJettyServer();
            server2 = this.createJettyServer();
            Context context = new Context();
            context.setContextPath("/");
            context.addServlet(firstServletClass, "/*");
            context.setAttribute("mapred.ha.active.jobtracker.baseurl", (Object)this.getJettyURL(server2).toExternalForm());
            server1.addHandler((Handler)context);
            context = new Context();
            context.setContextPath("/");
            context.addServlet(secondServlet, "/*");
            context.setAttribute("mapred.ha.active.jobtracker.baseurl", (Object)this.getJettyURL(server1).toExternalForm());
            server2.addHandler((Handler)context);
            server1.start();
            server2.start();
            URL url = new URL(this.getJettyURL(server1), "/bar");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Assert.assertEquals((long)expectedResponse, (long)conn.getResponseCode());
        }
        finally {
            if (server1 != null) {
                server1.stop();
            }
            if (server2 != null) {
                server1.stop();
            }
        }
    }

    @Test
    public void redirectOK() throws Exception {
        this.testRedirect(JobTrackerHAHttpRedirector.RedirectorServlet.class, OKServlet.class, 200);
    }

    @Test
    public void redirectLoop() throws Exception {
        this.testRedirect(JobTrackerHAHttpRedirector.RedirectorServlet.class, JobTrackerHAHttpRedirector.RedirectorServlet.class, 503);
    }

    public static class OKServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }
    }
}

