/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.HAUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHAUtil {
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.conf.set("mapred.job.tracker", "logicalName");
        this.conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtrackers", (String[])new String[]{"logicalName"}), "jt1,jt2");
        String JT1_ADDRESS = "1.2.3.4:8021";
        String JT2_ADDRESS = "localhost:8022";
        this.conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtracker.rpc-address", (String[])new String[]{"logicalName", "jt1"}), "1.2.3.4:8021");
        this.conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtracker.rpc-address", (String[])new String[]{"logicalName", "jt2"}), "localhost:8022");
    }

    @Test
    public void testGetLogicalNameIgnoresPort() {
        Configuration c = new Configuration();
        c.set("mapred.job.tracker", "myjt");
        Assert.assertEquals((Object)"myjt", (Object)HAUtil.getLogicalName((Configuration)c));
        c.set("mapred.job.tracker", "myjt:8021");
        Assert.assertEquals((Object)"myjt", (Object)HAUtil.getLogicalName((Configuration)c));
    }

    @Test
    public void testGetHaJtRpcAddresses() throws Exception {
        Map jtMap = HAUtil.getHaJtRpcAddresses((Configuration)this.conf);
        Assert.assertEquals((long)2L, (long)jtMap.size());
        InetSocketAddress addr = (InetSocketAddress)jtMap.get("jt1");
        Assert.assertEquals((Object)"1.2.3.4", (Object)addr.getHostName());
        Assert.assertEquals((long)8021L, (long)addr.getPort());
        addr = (InetSocketAddress)jtMap.get("jt2");
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)8022L, (long)addr.getPort());
    }

    @Test
    public void testGetJobTrackerId() throws Exception {
        Assert.assertEquals((String)"Matches localhost when mapred.ha.jobtracker.id not set", (Object)"jt2", (Object)HAUtil.getJobTrackerId((Configuration)this.conf));
        this.conf.set("mapred.ha.jobtracker.id", "jt1");
        Assert.assertEquals((String)"Honors mapred.ha.jobtracker.id if set", (Object)"jt1", (Object)HAUtil.getJobTrackerId((Configuration)this.conf));
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testGetJobTrackerIdWithNoMatch() throws Exception {
        this.conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtracker.rpc-address", (String[])new String[]{"logicalName", "jt2"}), "2.3.4.5:8022");
        HAUtil.getJobTrackerId((Configuration)this.conf);
    }

    @Test
    public void testGetJobTrackerIdOfOtherNode() throws Exception {
        Assert.assertEquals((String)"mapred.ha.jobtracker.id not set", (Object)"jt1", (Object)HAUtil.getJobTrackerIdOfOtherNode((Configuration)this.conf));
        this.conf.set("mapred.ha.jobtracker.id", "jt1");
        Assert.assertEquals((String)"mapred.ha.jobtracker.id set", (Object)"jt2", (Object)HAUtil.getJobTrackerIdOfOtherNode((Configuration)this.conf));
    }

    @Test
    public void testGetJtHaRpcAddress() throws Exception {
        String JT1_HA_ADDRESS = "1.2.3.4:10000";
        String JT2_HA_ADDRESS = "localhost:10000";
        this.conf.set(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.rpc-address", (String[])new String[]{"logicalName", "jt1"}), "1.2.3.4:10000");
        this.conf.set(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.rpc-address", (String[])new String[]{"logicalName", "jt2"}), "localhost:10000");
        Assert.assertEquals((String)"Matches localhost when mapred.ha.jobtracker.id not set", (Object)"localhost", (Object)HAUtil.getJtHaRpcAddress((Configuration)this.conf).getHostName());
        this.conf.set("mapred.ha.jobtracker.id", "jt1");
        Assert.assertEquals((String)"Honors mapred.ha.jobtracker.id if set", (Object)"1.2.3.4", (Object)HAUtil.getJtHaRpcAddress((Configuration)this.conf).getHostName());
    }
}

