/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.MiniMRHACluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestHAStateTransitionFailure {
    private static final Log LOG = LogFactory.getLog(TestHAStateTransitionFailure.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFailureToTransitionCausesShutdown() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRHACluster cluster = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).checkExitOnShutdown(false).build();
            DistributedFileSystem fs = dfs.getFileSystem();
            Path mapredSysDir = new Path(conf.get("mapred.system.dir"), "seq-000000000000");
            fs.mkdirs(mapredSysDir, new FsPermission(700));
            fs.setOwner(mapredSysDir, "mr", "mrgroup");
            final MiniMRHACluster finalCluster = cluster = new MiniMRHACluster(fs.getConf());
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"notmr", (String[])new String[]{"notmrgroup"});
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    finalCluster.getJobTrackerHaDaemon(0).makeActive();
                    return null;
                }
            });
            cluster.getJobTrackerHaDaemon(0).makeActive();
            Thread.sleep(1000L);
            Assert.assertTrue((String)"Should have called terminate", (boolean)ExitUtil.terminateCalled());
            GenericTestUtils.assertExceptionContains((String)"is not owned by", (Throwable)ExitUtil.getFirstExitException());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }
}

