/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.TestNodeFencer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobTrackerHADaemon;
import org.apache.hadoop.mapred.JobTrackerHAServiceTarget;
import org.apache.hadoop.mapred.MiniMRHACluster;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestHADelegationToken {
    private static final String TMP_DIR = new File("build/test/" + TestHADelegationToken.class.getSimpleName()).getAbsolutePath();
    private static MiniDFSCluster miniDFS = null;
    private MiniMRHACluster cluster;
    private JobTrackerHADaemon jt1;
    private JobTrackerHADaemon jt2;
    private JobTrackerHAServiceTarget target1;
    private JobTrackerHAServiceTarget target2;
    private Configuration conf;

    private void startCluster() throws Exception {
        this.startCluster(new Configuration());
    }

    private void startCluster(Configuration conf) throws Exception {
        ExitUtil.disableSystemExit();
        File tmpDir = new File(TMP_DIR);
        FileUtil.fullyDelete((File)tmpDir);
        tmpDir.mkdirs();
        this.conf = conf;
        conf.set("fs.hdfs.impl.disable.cache", "true");
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hadoop.tmp.dir", TMP_DIR);
        miniDFS = new MiniDFSCluster(conf, 1, true, null);
        DistributedFileSystem fileSystem = miniDFS.getFileSystem();
        fileSystem.mkdirs(new Path("/tmp"));
        fileSystem.mkdirs(new Path("/user"));
        fileSystem.mkdirs(new Path(TMP_DIR));
        fileSystem.mkdirs(new Path(TMP_DIR, "mapred"));
        fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        for (Path tmp = new Path(TMP_DIR, "mapred"); tmp != null; tmp = tmp.getParent()) {
            fileSystem.setPermission(tmp, new FsPermission(511));
        }
        conf.set("fs.default.name", fileSystem.getUri().toString());
        conf.set("mapred.ha.fencing.methods", TestNodeFencer.AlwaysSucceedFencer.class.getName());
        this.cluster = new MiniMRHACluster(conf);
        this.cluster.getJobTrackerHaDaemon(0).makeActive();
        this.cluster.startTaskTracker(0, 1);
        this.cluster.waitActive();
        this.jt1 = this.cluster.getJobTrackerHaDaemon(0);
        this.jt2 = this.cluster.getJobTrackerHaDaemon(1);
        this.target1 = new JobTrackerHAServiceTarget(this.jt1.getConf());
        this.target2 = new JobTrackerHAServiceTarget(this.jt2.getConf());
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            FileSystem.closeAll();
            miniDFS.shutdown();
        }
    }

    @Test
    public void tokenCloningServiceWithLogicalRealNames() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"alice", (String[])new String[]{"users"});
        this.startCluster();
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                JobClient jc = new JobClient(TestHADelegationToken.this.conf);
                Assert.assertFalse((boolean)TestHADelegationToken.this.conf.get("mapred.job.tracker").contains(":"));
                Token haToken = jc.getDelegationToken(new Text(UserGroupInformation.getCurrentUser().getShortUserName()));
                Assert.assertEquals((Object)HAUtil.buildTokenServiceForLogicalAddress((String)TestHADelegationToken.this.conf.get("mapred.job.tracker")), (Object)haToken.getService());
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                ugi.addToken(haToken);
                jc = new JobClient(TestHADelegationToken.this.conf);
                Collection tokensInUGI = ugi.getTokens();
                HashSet<Text> found = new HashSet<Text>();
                for (Token t : tokensInUGI) {
                    found.add(t.getService());
                }
                HashSet<Text> expected = new HashSet<Text>();
                Map map = HAUtil.getHaJtRpcAddresses((Configuration)TestHADelegationToken.this.conf);
                for (InetSocketAddress address : map.values()) {
                    expected.add(SecurityUtil.buildTokenService((InetSocketAddress)address));
                }
                expected.add(HAUtil.buildTokenServiceForLogicalAddress((String)TestHADelegationToken.this.conf.get("mapred.job.tracker")));
                Assert.assertEquals(expected, found);
                return null;
            }
        });
    }
}

