/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class TestFileInputFormat
extends TestCase {
    Configuration conf = new Configuration();
    MiniDFSCluster dfs = null;

    public void setUp() throws Exception {
        this.dfs = new MiniDFSCluster(this.conf, 4, true, new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}, new String[]{"host0", "host1", "host2", "host3"});
    }

    public void testLocality() throws Exception {
        JobConf job = new JobConf(this.conf);
        DistributedFileSystem fs = this.dfs.getFileSystem();
        System.out.println("FileSystem " + fs.getUri());
        Path inputDir = new Path("/foo/");
        String fileName = "part-0000";
        this.createInputs((FileSystem)fs, inputDir, fileName);
        TextInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        TextInputFormat inFormat = new TextInputFormat();
        inFormat.configure(job);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        FileStatus fileStatus = fs.getFileStatus(new Path(inputDir, fileName));
        BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
        System.out.println("Made splits");
        for (int i = 0; i < splits.length; ++i) {
            FileSplit fileSplit = (FileSplit)splits[i];
            System.out.println("File split: " + fileSplit);
            for (String h : fileSplit.getLocations()) {
                System.out.println("Location: " + h);
            }
            System.out.println("Block: " + locations[i]);
            TestFileInputFormat.assertEquals((long)locations[i].getOffset(), (long)fileSplit.getStart());
            TestFileInputFormat.assertEquals((long)locations[i].getLength(), (long)fileSplit.getLength());
            String[] blockLocs = locations[i].getHosts();
            String[] splitLocs = fileSplit.getLocations();
            TestFileInputFormat.assertEquals((int)2, (int)blockLocs.length);
            TestFileInputFormat.assertEquals((int)2, (int)splitLocs.length);
            TestFileInputFormat.assertTrue((blockLocs[0].equals(splitLocs[0]) && blockLocs[1].equals(splitLocs[1]) || blockLocs[1].equals(splitLocs[0]) && blockLocs[0].equals(splitLocs[1]) ? 1 : 0) != 0);
        }
        TestFileInputFormat.assertEquals((String)"Expected value of mapreduce.input.num.files", (long)1L, (long)job.getLong("mapreduce.input.num.files", 0L));
    }

    private void createInputs(FileSystem fs, Path inDir, String fileName) throws IOException, TimeoutException, InterruptedException {
        FSDataOutputStream out = fs.create(new Path(inDir, fileName), true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        System.out.println("Wrote file");
    }

    public void testNumInputs() throws Exception {
        JobConf job = new JobConf(this.conf);
        DistributedFileSystem fs = this.dfs.getFileSystem();
        System.out.println("FileSystem " + fs.getUri());
        Path inputDir = new Path("/foo/");
        int numFiles = 10;
        String fileNameBase = "part-0000";
        for (int i = 0; i < 10; ++i) {
            this.createInputs((FileSystem)fs, inputDir, fileNameBase + String.valueOf(i));
        }
        this.createInputs((FileSystem)fs, inputDir, "_meta");
        this.createInputs((FileSystem)fs, inputDir, "_temp");
        TextInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        TextInputFormat inFormat = new TextInputFormat();
        inFormat.configure(job);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        TestFileInputFormat.assertEquals((String)"Expected value of mapreduce.input.num.files", (long)10L, (long)job.getLong("mapreduce.input.num.files", 0L));
    }

    public void tearDown() throws Exception {
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }
}

