/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.junit.Assert;
import org.junit.Test;

public class TestCounters {
    private static final long MAX_VALUE = 10L;
    private static final Log LOG = LogFactory.getLog(TestCounters.class);

    private Counters getEnumCounters(Enum[] keys) {
        Counters counters = new Counters();
        for (Enum key : keys) {
            for (long i = 0L; i < 10L; ++i) {
                counters.incrCounter(key, i);
            }
        }
        return counters;
    }

    private Counters getEnumCounters(String[] gNames, String[] cNames) {
        Counters counters = new Counters();
        for (String gName : gNames) {
            for (String cName : cNames) {
                for (long i = 0L; i < 10L; ++i) {
                    counters.incrCounter(gName, cName, i);
                }
            }
        }
        return counters;
    }

    private void testCounter(Counters counter) throws ParseException {
        String compactEscapedString = counter.makeEscapedCompactString();
        Counters recoveredCounter = Counters.fromEscapedCompactString((String)compactEscapedString);
        Assert.assertEquals((String)"Recovered counter does not match on content", (Object)counter, (Object)recoveredCounter);
    }

    @Test
    public void testCounters() throws IOException {
        Enum[] keysWithResource = new Enum[]{TaskCounter.MAP_INPUT_RECORDS, TaskCounter.MAP_OUTPUT_BYTES};
        Enum[] keysWithoutResource = new Enum[]{myCounters.TEST1, myCounters.TEST2};
        String[] groups = new String[]{"group1", "group2", "group{}()[]"};
        String[] counters = new String[]{"counter1", "counter2", "counter{}()[]"};
        try {
            this.testCounter(this.getEnumCounters(keysWithResource));
            this.testCounter(this.getEnumCounters(keysWithoutResource));
            this.testCounter(this.getEnumCounters(groups, counters));
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
    }

    @Test
    public void testLegacyNames() {
        Counters counters = new Counters();
        counters.incrCounter((Enum)TaskCounter.MAP_INPUT_RECORDS, 1L);
        counters.incrCounter((Enum)JobCounter.DATA_LOCAL_MAPS, 1L);
        ((Counters.Counter)counters.findCounter("file", FileSystemCounter.BYTES_READ)).increment(1L);
        Assert.assertEquals((String)"New name", (long)1L, (long)counters.findCounter(TaskCounter.class.getName(), "MAP_INPUT_RECORDS").getValue());
        Assert.assertEquals((String)"Legacy name", (long)1L, (long)counters.findCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_INPUT_RECORDS").getValue());
        Assert.assertEquals((String)"New name", (long)1L, (long)counters.findCounter(JobCounter.class.getName(), "DATA_LOCAL_MAPS").getValue());
        Assert.assertEquals((String)"Legacy name", (long)1L, (long)counters.findCounter("org.apache.hadoop.mapred.JobInProgress$Counter", "DATA_LOCAL_MAPS").getValue());
        Assert.assertEquals((String)"New name", (long)1L, (long)counters.findCounter(FileSystemCounter.class.getName(), "FILE_BYTES_READ").getValue());
        Assert.assertEquals((String)"New name and method", (long)1L, (long)((Counters.Counter)counters.findCounter("file", FileSystemCounter.BYTES_READ)).getValue());
        Assert.assertEquals((String)"Legacy name", (long)1L, (long)counters.findCounter("FileSystemCounters", "FILE_BYTES_READ").getValue());
    }

    @Test
    public void testCounterIteratorConcurrency() {
        Counters counters = new Counters();
        counters.incrCounter("group1", "counter1", 1L);
        Iterator iterator = counters.iterator();
        counters.incrCounter("group2", "counter2", 1L);
        iterator.next();
    }

    @Test
    public void testGroupIteratorConcurrency() {
        Counters counters = new Counters();
        counters.incrCounter("group1", "counter1", 1L);
        Counters.Group group = counters.getGroup("group1");
        Iterator iterator = group.iterator();
        counters.incrCounter("group1", "counter2", 1L);
        iterator.next();
    }

    @Test
    public void testFileSystemGroupIteratorConcurrency() {
        Counters counters = new Counters();
        ((Counters.Counter)counters.findCounter("fs1", FileSystemCounter.BYTES_READ)).increment(1L);
        ((Counters.Counter)counters.findCounter("fs2", FileSystemCounter.BYTES_READ)).increment(1L);
        Counters.Group group = counters.getGroup(FileSystemCounter.class.getName());
        Iterator iterator = group.iterator();
        ((Counters.Counter)counters.findCounter("fs3", FileSystemCounter.BYTES_READ)).increment(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        ((Counters.Counter)counters.findCounter("fs3", FileSystemCounter.BYTES_READ)).increment(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
    }

    public static void main(String[] args) throws IOException {
        new TestCounters().testCounters();
    }

    static enum myCounters {
        TEST1,
        TEST2;

    }
}

