/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerHADaemon;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.util.ExitUtil;

public class MiniMRHACluster {
    private static final Log LOG = LogFactory.getLog(MiniMRHACluster.class);
    public static final String LOGICAL_NAME = "logicaljt";
    private Configuration conf;
    private List<JobTrackerHADaemon> jtHaDaemonList = new ArrayList<JobTrackerHADaemon>();
    private List<TaskTrackerRunner> taskTrackerList = new ArrayList<TaskTrackerRunner>();
    private List<Thread> taskTrackerThreadList = new ArrayList<Thread>();

    public MiniMRHACluster() throws IOException, InterruptedException {
        this(new Configuration());
    }

    public MiniMRHACluster(Configuration conf) throws IOException, InterruptedException {
        this(conf, 2, 1);
    }

    public MiniMRHACluster(Configuration conf, int numJobTrackers, int numTaskTrackers) throws IOException, InterruptedException {
        this.conf = conf;
        ExitUtil.disableSystemExit();
        MiniMRHACluster.configureLogicalName(conf);
        for (int i = 0; i < numJobTrackers; ++i) {
            JobTrackerHADaemon jtHaDaemon = MiniMRHACluster.createJobTrackerHADaemon(conf, "jt" + (i + 1));
            jtHaDaemon.start();
            this.jtHaDaemonList.add(jtHaDaemon);
            Thread.sleep(1000L);
        }
    }

    public JobTrackerHADaemon getJobTrackerHaDaemon(int index) {
        return this.jtHaDaemonList.get(index);
    }

    public Configuration getClientConf() {
        return this.conf;
    }

    private static JobTrackerHADaemon createJobTrackerHADaemon(Configuration conf, String jtId) throws IOException {
        Configuration c = new Configuration(conf);
        c.setBoolean("mapred.jobtracker.restart.recover", true);
        c.set("mapred.ha.jobtracker.id", jtId);
        return new JobTrackerHADaemon(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findEphemeralPort() throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static void configureLogicalName(Configuration conf) throws IOException {
        String jt1Id = "jt1";
        String jt2Id = "jt2";
        String jt1Address = "localhost:" + MiniMRHACluster.findEphemeralPort();
        String jt2Address = "localhost:" + MiniMRHACluster.findEphemeralPort();
        String jt1HaAddress = "localhost:" + MiniMRHACluster.findEphemeralPort();
        String jt2HaAddress = "localhost:" + MiniMRHACluster.findEphemeralPort();
        String jt1HttpAddress = "0.0.0.0:" + MiniMRHACluster.findEphemeralPort();
        String jt2HttpAddress = "0.0.0.0:" + MiniMRHACluster.findEphemeralPort();
        String jt1HttpRedirectAddress = jt1HttpAddress.replace("0.0.0.0", "localhost");
        String jt2HttpRedirectAddress = jt2HttpAddress.replace("0.0.0.0", "localhost");
        conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtracker.rpc-address", (String[])new String[]{LOGICAL_NAME, jt1Id}), jt1Address);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtracker.rpc-address", (String[])new String[]{LOGICAL_NAME, jt2Id}), jt2Address);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.rpc-address", (String[])new String[]{LOGICAL_NAME, jt1Id}), jt1HaAddress);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.rpc-address", (String[])new String[]{LOGICAL_NAME, jt2Id}), jt2HaAddress);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.job.tracker.http.address", (String[])new String[]{LOGICAL_NAME, jt1Id}), jt1HttpAddress);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.job.tracker.http.address", (String[])new String[]{LOGICAL_NAME, jt2Id}), jt2HttpAddress);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.http-redirect-address", (String[])new String[]{LOGICAL_NAME, jt1Id}), jt1HttpRedirectAddress);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.ha.jobtracker.http-redirect-address", (String[])new String[]{LOGICAL_NAME, jt2Id}), jt2HttpRedirectAddress);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.jobtrackers", (String[])new String[]{LOGICAL_NAME}), jt1Id + "," + jt2Id);
        conf.set(HAUtil.addKeySuffixes((String)"mapred.client.failover.proxy.provider", (String[])new String[]{LOGICAL_NAME}), ConfiguredFailoverProxyProvider.class.getName());
        conf.set("mapred.job.tracker", LOGICAL_NAME);
    }

    public void waitActive() throws IOException {
        while (true) {
            for (JobTrackerHADaemon jtHaDaemon : this.jtHaDaemonList) {
                JobTracker jt = jtHaDaemon.getJobTracker();
                if (jt == null || jt.getClusterStatus().getJobTrackerStatus() != Cluster.JobTrackerStatus.RUNNING) continue;
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void startTaskTracker(int idx, int numDir) throws IOException {
        TaskTrackerRunner taskTracker = new TaskTrackerRunner(idx, numDir, null, new JobConf(this.conf));
        this.addTaskTracker(taskTracker);
    }

    void addTaskTracker(TaskTrackerRunner taskTracker) {
        Thread taskTrackerThread = new Thread(taskTracker);
        this.taskTrackerList.add(taskTracker);
        this.taskTrackerThreadList.add(taskTrackerThread);
        taskTrackerThread.start();
    }

    private void waitTaskTrackers() {
        for (TaskTrackerRunner runner : this.taskTrackerList) {
            while (!(runner.isDead || runner.isInitialized && runner.tt.isIdle())) {
                if (!runner.isInitialized) {
                    LOG.info((Object)"Waiting for task tracker to start.");
                } else {
                    LOG.info((Object)("Waiting for task tracker " + runner.tt.getName() + " to be idle."));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void shutdownJobTracker(int index) {
        JobTrackerHADaemon jtHaDaemon = this.jtHaDaemonList.get(index);
        try {
            jtHaDaemon.stop();
        }
        catch (IOException ex) {
            LOG.error((Object)"Problem shutting down jobtracker HA daemon", (Throwable)ex);
        }
        jtHaDaemon.join();
    }

    public void shutdown() {
        this.waitTaskTrackers();
        for (int idx = 0; idx < this.taskTrackerList.size(); ++idx) {
            TaskTrackerRunner taskTracker = this.taskTrackerList.get(idx);
            Thread taskTrackerThread = this.taskTrackerThreadList.get(idx);
            taskTracker.shutdown();
            taskTrackerThread.interrupt();
            try {
                taskTrackerThread.join();
                continue;
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Problem shutting down task tracker", (Throwable)ex);
            }
        }
        for (JobTrackerHADaemon jtHaDaemon : this.jtHaDaemonList) {
            try {
                jtHaDaemon.stop();
            }
            catch (IOException ex) {
                LOG.error((Object)"Problem shutting down jobtracker HA daemon", (Throwable)ex);
            }
            jtHaDaemon.join();
        }
    }

    static class TaskTrackerRunner
    implements Runnable {
        volatile TaskTracker tt;
        int trackerId;
        String[] localDirs;
        volatile boolean isInitialized = false;
        volatile boolean isDead = false;
        volatile boolean exited = false;
        int numDir;

        public TaskTrackerRunner(int trackerId, int numDir, String hostname, JobConf cfg) throws IOException {
            this.trackerId = trackerId;
            this.numDir = numDir;
            this.localDirs = new String[numDir];
            JobConf conf = cfg;
            if (hostname != null) {
                conf.set("slave.host.name", hostname);
            }
            conf.set("mapred.task.tracker.http.address", "0.0.0.0:0");
            conf.set("mapred.task.tracker.report.address", "127.0.0.1:0");
            File localDirBase = new File(conf.get("mapred.local.dir")).getAbsoluteFile();
            localDirBase.mkdirs();
            StringBuffer localPath = new StringBuffer();
            for (int i = 0; i < numDir; ++i) {
                File ttDir = new File(localDirBase, Integer.toString(trackerId) + "_" + i);
                if (!ttDir.mkdirs() && !ttDir.isDirectory()) {
                    throw new IOException("Mkdirs failed to create " + ttDir);
                }
                this.localDirs[i] = ttDir.toString();
                if (i != 0) {
                    localPath.append(",");
                }
                localPath.append(this.localDirs[i]);
            }
            conf.set("mapred.local.dir", localPath.toString());
            try {
                this.tt = this.createTaskTracker(conf);
                this.isInitialized = true;
            }
            catch (Throwable e) {
                this.isDead = true;
                this.tt = null;
                e.printStackTrace();
            }
        }

        TaskTracker createTaskTracker(JobConf conf) throws IOException, InterruptedException {
            return new TaskTracker(conf);
        }

        @Override
        public void run() {
            try {
                if (this.tt != null) {
                    this.tt.run();
                }
            }
            catch (Throwable e) {
                this.isDead = true;
                this.tt = null;
                e.printStackTrace();
            }
            this.exited = true;
        }

        public String getLocalDir() {
            return this.localDirs[0];
        }

        public String[] getLocalDirs() {
            return this.localDirs;
        }

        public TaskTracker getTaskTracker() {
            return this.tt;
        }

        public void shutdown() {
            if (this.tt != null) {
                try {
                    this.tt.shutdown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

