/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestHAAppend {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppendsDuringCatchupTailing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.ha.tail-edits.period", "5000");
        conf.setInt("dfs.ha.log-roll.period", -1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        FileSystem fs = null;
        try {
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            Path fileToAppend = new Path("/FileToAppend");
            FSDataOutputStream out = fs.create(fileToAppend);
            out.writeBytes("/data");
            out.hflush();
            cluster.getNameNode(0).getRpcServer().rollEditLog();
            cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
            out.close();
            for (int i = 0; i < 5; ++i) {
                DFSTestUtil.appendFile(fs, fileToAppend, "data");
            }
            cluster.triggerBlockReports();
            cluster.shutdownNameNode(0);
            cluster.transitionToActive(1);
            int rc = ToolRunner.run((Tool)new DFSck(cluster.getConfiguration(1)), (String[])new String[]{"/", "-files", "-blocks"});
            Assert.assertEquals((long)0L, (long)rc);
            Assert.assertEquals((String)"CorruptBlocks should be empty.", (long)0L, (long)cluster.getNameNode(1).getNamesystem().getCorruptReplicaBlocks());
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
            }
            if (null != fs) {
                fs.close();
            }
        }
    }
}

