/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.sun.jndi.ldap.LdapCtxFactory;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.GroupMappingServiceProvider;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class LdapGroupsMapping
implements GroupMappingServiceProvider,
Configurable {
    public static final String LDAP_CONFIG_PREFIX = "hadoop.security.group.mapping.ldap";
    public static final String LDAP_URL_KEY = "hadoop.security.group.mapping.ldap.url";
    public static final String LDAP_URL_DEFAULT = "";
    public static final String LDAP_USE_SSL_KEY = "hadoop.security.group.mapping.ldap.ssl";
    public static final Boolean LDAP_USE_SSL_DEFAULT = false;
    public static final String LDAP_KEYSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore";
    public static final String LDAP_KEYSTORE_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password";
    public static final String LDAP_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password.file";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_DEFAULT = "";
    public static final String BIND_USER_KEY = "hadoop.security.group.mapping.ldap.bind.user";
    public static final String BIND_USER_DEFAULT = "";
    public static final String BIND_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.bind.password";
    public static final String BIND_PASSWORD_DEFAULT = "";
    public static final String BIND_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.bind.password.file";
    public static final String BIND_PASSWORD_FILE_DEFAULT = "";
    public static final String BASE_DN_KEY = "hadoop.security.group.mapping.ldap.base";
    public static final String BASE_DN_DEFAULT = "";
    public static final String USER_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.user";
    public static final String USER_SEARCH_FILTER_DEFAULT = "(&(objectClass=user)(sAMAccountName={0}))";
    public static final String GROUP_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.group";
    public static final String GROUP_SEARCH_FILTER_DEFAULT = "(objectClass=group)";
    public static final String MEMBEROF_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.memberof";
    public static final String MEMBEROF_ATTR_DEFAULT = "";
    public static final String GROUP_MEMBERSHIP_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.member";
    public static final String GROUP_MEMBERSHIP_ATTR_DEFAULT = "member";
    public static final String GROUP_NAME_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.group.name";
    public static final String GROUP_NAME_ATTR_DEFAULT = "cn";
    public static final String POSIX_UID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.uid.name";
    public static final String POSIX_UID_ATTR_DEFAULT = "uidNumber";
    public static final String POSIX_GID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.gid.name";
    public static final String POSIX_GID_ATTR_DEFAULT = "gidNumber";
    public static final String POSIX_GROUP = "posixGroup";
    public static final String POSIX_ACCOUNT = "posixAccount";
    public static final String DIRECTORY_SEARCH_TIMEOUT = "hadoop.security.group.mapping.ldap.directory.search.timeout";
    public static final int DIRECTORY_SEARCH_TIMEOUT_DEFAULT = 10000;
    private static final Log LOG = LogFactory.getLog(LdapGroupsMapping.class);
    private static final SearchControls SEARCH_CONTROLS = new SearchControls();
    private DirContext ctx;
    private Configuration conf;
    private String ldapUrl;
    private boolean useSsl;
    private String keystore;
    private String keystorePass;
    private String bindUser;
    private String bindPassword;
    private String baseDN;
    private String groupSearchFilter;
    private String userSearchFilter;
    private String memberOfAttr;
    private String groupMemberAttr;
    private String groupNameAttr;
    private String posixUidAttr;
    private String posixGidAttr;
    private boolean isPosix;
    private boolean useOneQuery;
    public static final int RECONNECT_RETRY_COUNT = 3;

    @Override
    public synchronized List<String> getGroups(String user) {
        for (int retry = 0; retry < 3; ++retry) {
            try {
                return this.doGetGroups(user);
            }
            catch (NamingException e) {
                LOG.warn((Object)("Failed to get groups for user " + user + " (retry=" + retry + ") by " + e));
                LOG.trace((Object)"TRACE", (Throwable)e);
                this.ctx = null;
                continue;
            }
        }
        return Collections.emptyList();
    }

    private String getRelativeDistinguishedName(String distinguishedName) throws NamingException {
        LdapName ldn = new LdapName(distinguishedName);
        List<Rdn> rdns = ldn.getRdns();
        if (rdns.isEmpty()) {
            throw new NamingException("DN is empty");
        }
        Rdn rdn = rdns.get(rdns.size() - 1);
        if (rdn.getType().equalsIgnoreCase(this.groupNameAttr)) {
            String groupName = (String)rdn.getValue();
            return groupName;
        }
        throw new NamingException("Unable to find RDN: The DN " + distinguishedName + " is malformed.");
    }

    private NamingEnumeration<SearchResult> lookupPosixGroup(SearchResult result, DirContext c) throws NamingException {
        String gidNumber = null;
        String uidNumber = null;
        Attribute gidAttribute = result.getAttributes().get(this.posixGidAttr);
        Attribute uidAttribute = result.getAttributes().get(this.posixUidAttr);
        String reason = "";
        if (gidAttribute == null) {
            reason = "Can't find attribute '" + this.posixGidAttr + "'.";
        } else {
            gidNumber = gidAttribute.get().toString();
        }
        if (uidAttribute == null) {
            reason = "Can't find attribute '" + this.posixUidAttr + "'.";
        } else {
            uidNumber = uidAttribute.get().toString();
        }
        if (uidNumber != null && gidNumber != null) {
            return c.search(this.baseDN, "(&" + this.groupSearchFilter + "(|(" + this.posixGidAttr + "={0})" + "(" + this.groupMemberAttr + "={1})))", new Object[]{gidNumber, uidNumber}, SEARCH_CONTROLS);
        }
        throw new NamingException("The server does not support posixGroups semantics. Reason: " + reason + " Returned user object: " + result.toString());
    }

    private List<String> lookupGroup(SearchResult result, DirContext c) throws NamingException {
        ArrayList<String> groups = new ArrayList<String>();
        NamingEnumeration<SearchResult> groupResults = null;
        if (this.isPosix) {
            groupResults = this.lookupPosixGroup(result, c);
        } else {
            String userDn = result.getNameInNamespace();
            groupResults = c.search(this.baseDN, "(&" + this.groupSearchFilter + "(" + this.groupMemberAttr + "={0}))", new Object[]{userDn}, SEARCH_CONTROLS);
        }
        if (groupResults != null) {
            while (groupResults.hasMoreElements()) {
                SearchResult groupResult = (SearchResult)groupResults.nextElement();
                Attribute groupName = groupResult.getAttributes().get(this.groupNameAttr);
                if (groupName == null) {
                    throw new NamingException("The group object does not have attribute '" + this.groupNameAttr + "'.");
                }
                groups.add(groupName.get().toString());
            }
        }
        return groups;
    }

    List<String> doGetGroups(String user) throws NamingException {
        DirContext c = this.getDirContext();
        NamingEnumeration<SearchResult> results = c.search(this.baseDN, this.userSearchFilter, new Object[]{user}, SEARCH_CONTROLS);
        if (!results.hasMoreElements()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("doGetGroups(" + user + ") return no groups because the " + "user is not found."));
            }
            return new ArrayList<String>();
        }
        SearchResult result = (SearchResult)results.nextElement();
        List<String> groups = null;
        if (this.useOneQuery) {
            try {
                Attribute groupDNAttr = result.getAttributes().get(this.memberOfAttr);
                if (groupDNAttr == null) {
                    throw new NamingException("The user object does not have '" + this.memberOfAttr + "' attribute." + "Returned user object: " + result.toString());
                }
                groups = new ArrayList<String>();
                NamingEnumeration<?> groupEnumeration = groupDNAttr.getAll();
                while (groupEnumeration.hasMore()) {
                    String groupDN = groupEnumeration.next().toString();
                    groups.add(this.getRelativeDistinguishedName(groupDN));
                }
            }
            catch (NamingException e) {
                LOG.info((Object)"Failed to get groups from the first lookup. Initiating the second LDAP query using the user's DN.", (Throwable)e);
            }
        }
        if (groups == null || groups.isEmpty()) {
            groups = this.lookupGroup(result, c);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doGetGroups(" + user + ") return " + groups));
        }
        return groups;
    }

    DirContext getDirContext() throws NamingException {
        if (this.ctx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", LdapCtxFactory.class.getName());
            env.put("java.naming.provider.url", this.ldapUrl);
            env.put("java.naming.security.authentication", "simple");
            if (this.useSsl) {
                env.put("java.naming.security.protocol", "ssl");
                System.setProperty("javax.net.ssl.keyStore", this.keystore);
                System.setProperty("javax.net.ssl.keyStorePassword", this.keystorePass);
            }
            env.put("java.naming.security.principal", this.bindUser);
            env.put("java.naming.security.credentials", this.bindPassword);
            this.ctx = new InitialDirContext(env);
        }
        return this.ctx;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.ldapUrl = conf.get(LDAP_URL_KEY, "");
        if (this.ldapUrl == null || this.ldapUrl.isEmpty()) {
            throw new RuntimeException("LDAP URL is not configured");
        }
        this.useSsl = conf.getBoolean(LDAP_USE_SSL_KEY, LDAP_USE_SSL_DEFAULT);
        this.keystore = conf.get(LDAP_KEYSTORE_KEY, "");
        this.keystorePass = this.getPassword(conf, LDAP_KEYSTORE_PASSWORD_KEY, "");
        if (this.keystorePass.isEmpty()) {
            this.keystorePass = this.extractPassword(conf.get(LDAP_KEYSTORE_PASSWORD_FILE_KEY, ""));
        }
        this.bindUser = conf.get(BIND_USER_KEY, "");
        this.bindPassword = this.getPassword(conf, BIND_PASSWORD_KEY, "");
        if (this.bindPassword.isEmpty()) {
            this.bindPassword = this.extractPassword(conf.get(BIND_PASSWORD_FILE_KEY, ""));
        }
        this.baseDN = conf.get(BASE_DN_KEY, "");
        this.groupSearchFilter = conf.get(GROUP_SEARCH_FILTER_KEY, GROUP_SEARCH_FILTER_DEFAULT);
        this.userSearchFilter = conf.get(USER_SEARCH_FILTER_KEY, USER_SEARCH_FILTER_DEFAULT);
        this.isPosix = this.groupSearchFilter.contains(POSIX_GROUP) && this.userSearchFilter.contains(POSIX_ACCOUNT);
        this.memberOfAttr = conf.get(MEMBEROF_ATTR_KEY, "");
        this.useOneQuery = !this.memberOfAttr.isEmpty();
        this.groupMemberAttr = conf.get(GROUP_MEMBERSHIP_ATTR_KEY, GROUP_MEMBERSHIP_ATTR_DEFAULT);
        this.groupNameAttr = conf.get(GROUP_NAME_ATTR_KEY, GROUP_NAME_ATTR_DEFAULT);
        this.posixUidAttr = conf.get(POSIX_UID_ATTR_KEY, POSIX_UID_ATTR_DEFAULT);
        this.posixGidAttr = conf.get(POSIX_GID_ATTR_KEY, POSIX_GID_ATTR_DEFAULT);
        int dirSearchTimeout = conf.getInt(DIRECTORY_SEARCH_TIMEOUT, 10000);
        SEARCH_CONTROLS.setTimeLimit(dirSearchTimeout);
        String[] returningAttributes = this.useOneQuery ? new String[]{this.groupNameAttr, this.posixUidAttr, this.posixGidAttr, this.memberOfAttr} : new String[]{this.groupNameAttr, this.posixUidAttr, this.posixGidAttr};
        SEARCH_CONTROLS.setReturningAttributes(returningAttributes);
        this.conf = conf;
    }

    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Exception while trying to get password for alias " + alias + ": "), (Throwable)ioe);
        }
        return password;
    }

    String extractPassword(String pwFile) {
        String string;
        if (pwFile.isEmpty()) {
            return "";
        }
        FileReader reader = null;
        try {
            StringBuilder password = new StringBuilder();
            reader = new FileReader(pwFile);
            int c = ((Reader)reader).read();
            while (c > -1) {
                password.append((char)c);
                c = ((Reader)reader).read();
            }
            string = password.toString().trim();
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Could not read password file: " + pwFile, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, reader);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, reader);
        return string;
    }

    static {
        SEARCH_CONTROLS.setSearchScope(2);
    }
}

