/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.common.propertyeditor;

import java.math.BigDecimal;

/**
 * A property editor for BigDecimal typed properties.
 *
 * @version $Rev: 487175 $
 */
public class BigDecimalEditor extends TextPropertyEditorSupport {
    /**
     * Convert the text value of the property into a BigDecimal instance.
     *
     * @return a BigDecimal object constructed from the property text value.
     */
    public Object getValue() {
        try {
            // just instantiate a BigDecimal instance from the test string value.
            return new BigDecimal(getAsText().trim());
        } catch (NumberFormatException e) {
            // any format errors show up as a NumberFormatException, which we turn into a PropertyEditorException.
            throw new PropertyEditorException(e);
        }
    }
}
