/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.util.AbstractID;

public class SimpleSlot
extends Slot {
    private static final AtomicReferenceFieldUpdater<SimpleSlot, Execution> VERTEX_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SimpleSlot.class, Execution.class, "executedTask");
    private volatile Execution executedTask;
    private Locality locality = Locality.UNCONSTRAINED;

    public SimpleSlot(JobID jobID, Instance instance, int slotNumber) {
        super(jobID, instance, slotNumber, null, null);
    }

    public SimpleSlot(JobID jobID, Instance instance, int slotNumber, SharedSlot parent, AbstractID groupID) {
        super(jobID, instance, slotNumber, parent, groupID);
    }

    @Override
    public int getNumberLeaves() {
        return 1;
    }

    public Execution getExecutedVertex() {
        return this.executedTask;
    }

    public boolean setExecutedVertex(Execution executedVertex) {
        if (executedVertex == null) {
            throw new NullPointerException();
        }
        if (this.isCanceled()) {
            return false;
        }
        if (!VERTEX_UPDATER.compareAndSet(this, null, executedVertex)) {
            return false;
        }
        if (this.isCanceled()) {
            this.executedTask = null;
            return false;
        }
        return true;
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    @Override
    public void releaseSlot() {
        if (!this.isCanceled()) {
            Execution exec = this.executedTask;
            if (exec != null && !exec.isFinished()) {
                exec.fail(new Exception("The slot in which the task was executed has been released. Probably loss of TaskManager " + this.getInstance()));
            }
            if (this.getParent() == null) {
                if (this.markCancelled()) {
                    this.getInstance().returnAllocatedSlot(this);
                }
            } else {
                this.getParent().releaseChild(this);
            }
        }
    }

    @Override
    public String toString() {
        return "SimpleSlot " + super.toString();
    }
}

