/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import akka.actor.UntypedActor;
import java.util.UUID;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.RequiresLeaderSessionID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkUntypedActor
extends UntypedActor {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public final void onReceive(Object message) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Received message {} at {} from {}.", new Object[]{message, this.getSelf().path(), this.getSender()});
            long start = System.nanoTime();
            this.handleLeaderSessionID(message);
            long duration = (System.nanoTime() - start) / 1000000L;
            this.LOG.debug("Handled message {} in {} ms from {}.", new Object[]{message, duration, this.getSender()});
        } else {
            this.handleLeaderSessionID(message);
        }
    }

    private void handleLeaderSessionID(Object message) throws Exception {
        if (message instanceof JobManagerMessages.LeaderSessionMessage) {
            UUID actualID;
            JobManagerMessages.LeaderSessionMessage msg = (JobManagerMessages.LeaderSessionMessage)message;
            UUID expectedID = this.getLeaderSessionID();
            if (expectedID == (actualID = msg.leaderSessionID()) || expectedID != null && expectedID.equals(actualID)) {
                this.handleMessage(msg.message());
            } else {
                this.handleDiscardedMessage(expectedID, msg);
            }
        } else {
            if (message instanceof RequiresLeaderSessionID) {
                throw new Exception("Received a message " + message + " without a leader session ID, even though the message requires a leader session ID.");
            }
            this.handleMessage(message);
        }
    }

    private void handleDiscardedMessage(UUID expectedLeaderSessionID, JobManagerMessages.LeaderSessionMessage msg) {
        this.LOG.warn("Discard message {} because the expected leader session ID {} did not equal the received leader session ID {}.", new Object[]{msg, expectedLeaderSessionID, msg.leaderSessionID()});
    }

    protected abstract void handleMessage(Object var1) throws Exception;

    protected abstract UUID getLeaderSessionID();

    protected Object decorateMessage(Object message) {
        if (message instanceof RequiresLeaderSessionID) {
            return new JobManagerMessages.LeaderSessionMessage(this.getLeaderSessionID(), message);
        }
        return message;
    }
}

