/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.gssapi;

import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslCallbackHandler;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssapiCallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GssapiCallbackHandler.class);

    public GssapiCallbackHandler(LdapSession ldapSession, CoreSession adminSession, InternalBindRequest bindRequest) {
        super(adminSession.getDirectoryService(), bindRequest);
        this.ldapSession = ldapSession;
        this.adminSession = adminSession;
    }

    protected EntryAttribute lookupPassword(String username, String password) {
        return null;
    }

    protected void authorize(AuthorizeCallback authorizeCB) throws Exception {
        LOG.debug("Processing conversion of principal name to DN.");
        String username = authorizeCB.getAuthorizationID();
        GetPrincipal getPrincipal = new GetPrincipal(new KerberosPrincipal(username));
        PrincipalStoreEntry entry = (PrincipalStoreEntry)getPrincipal.execute(this.adminSession, new DN(this.ldapSession.getLdapServer().getSearchBaseDn()));
        String bindDn = entry.getDistinguishedName();
        LOG.debug("Converted username {} to DN {}.", (Object)username, (Object)bindDn);
        LdapPrincipal ldapPrincipal = new LdapPrincipal(new DN(entry.getDistinguishedName()), AuthenticationLevel.STRONG, StringTools.EMPTY_BYTES);
        this.ldapSession.putSaslProperty("saslAuthentUser", ldapPrincipal);
        this.ldapSession.putSaslProperty("java.naming.security.principal", bindDn);
        authorizeCB.setAuthorizedID(bindDn);
        authorizeCB.setAuthorized(true);
    }
}

