/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import org.apache.calcite.adapter.druid.ExtractionDimensionSpec;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.adapter.druid.TimeExtractionFunction;

public class TimeExtractionDimensionSpec
extends ExtractionDimensionSpec {
    public TimeExtractionDimensionSpec(ExtractionFunction extractionFunction, String outputName) {
        super("__time", extractionFunction, outputName);
    }

    public static TimeExtractionDimensionSpec makeFullTimeExtract(String outputName, String timeZone) {
        return new TimeExtractionDimensionSpec(TimeExtractionFunction.createDefault(timeZone), outputName);
    }

    public static TimeExtractionDimensionSpec makeTimeExtract(Granularity granularity, String outputName, String timeZone) {
        return new TimeExtractionDimensionSpec(TimeExtractionFunction.createExtractFromGranularity(granularity, timeZone), outputName);
    }

    public static TimeExtractionDimensionSpec makeTimeFloor(Granularity granularity, String outputName, String timeZone) {
        TimeExtractionFunction fn = TimeExtractionFunction.createFloorFromGranularity(granularity, timeZone);
        return new TimeExtractionDimensionSpec(fn, outputName);
    }
}

