/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.rules.AggregateFilterTransposeRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectSortTransposeRule;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.joda.time.Interval;
import org.slf4j.Logger;

public class DruidRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    public static final DruidFilterRule FILTER = new DruidFilterRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectRule PROJECT = new DruidProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateRule AGGREGATE = new DruidAggregateRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateProjectRule AGGREGATE_PROJECT = new DruidAggregateProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidSortRule SORT = new DruidSortRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidSortProjectTransposeRule SORT_PROJECT_TRANSPOSE = new DruidSortProjectTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectSortTransposeRule PROJECT_SORT_TRANSPOSE = new DruidProjectSortTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectFilterTransposeRule PROJECT_FILTER_TRANSPOSE = new DruidProjectFilterTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidFilterProjectTransposeRule FILTER_PROJECT_TRANSPOSE = new DruidFilterProjectTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateFilterTransposeRule AGGREGATE_FILTER_TRANSPOSE = new DruidAggregateFilterTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidFilterAggregateTransposeRule FILTER_AGGREGATE_TRANSPOSE = new DruidFilterAggregateTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidPostAggregationProjectRule POST_AGGREGATION_PROJECT = new DruidPostAggregationProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final List<RelOptRule> RULES = ImmutableList.of((Object)((Object)FILTER), (Object)((Object)PROJECT_FILTER_TRANSPOSE), (Object)((Object)AGGREGATE_PROJECT), (Object)((Object)PROJECT), (Object)((Object)POST_AGGREGATION_PROJECT), (Object)((Object)AGGREGATE), (Object)((Object)FILTER_AGGREGATE_TRANSPOSE), (Object)((Object)FILTER_PROJECT_TRANSPOSE), (Object)((Object)PROJECT_SORT_TRANSPOSE), (Object)((Object)SORT), (Object)((Object)SORT_PROJECT_TRANSPOSE));
    private static final Predicate<Triple<Aggregate, RelNode, DruidQuery>> BAD_AGG = new PredicateImpl<Triple<Aggregate, RelNode, DruidQuery>>(){

        public boolean test(Triple<Aggregate, RelNode, DruidQuery> triple) {
            Aggregate aggregate = (Aggregate)triple.getLeft();
            RelNode node = (RelNode)triple.getMiddle();
            DruidQuery query = (DruidQuery)((Object)triple.getRight());
            CalciteConnectionConfig config = query.getConnectionConfig();
            block4: for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                switch (aggregateCall.getAggregation().getKind()) {
                    case COUNT: {
                        if (DruidRules.checkAggregateOnMetric(ImmutableBitSet.of((Iterable)aggregateCall.getArgList()), node, query)) {
                            return true;
                        }
                        if (aggregateCall.isDistinct() && (aggregateCall.isApproximate() || config.approximateDistinctCount()) || aggregateCall.getArgList().isEmpty()) continue block4;
                        return true;
                    }
                    case SUM: 
                    case SUM0: 
                    case MIN: 
                    case MAX: {
                        RelDataType type = aggregateCall.getType();
                        SqlTypeName sqlTypeName = type.getSqlTypeName();
                        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains(sqlTypeName) || SqlTypeFamily.INTEGER.getTypeNames().contains(sqlTypeName)) continue block4;
                        if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains(sqlTypeName)) {
                            assert (sqlTypeName == SqlTypeName.DECIMAL);
                            if (type.getScale() == 0 || config.approximateDecimal()) continue block4;
                        }
                        return true;
                    }
                }
                return true;
            }
            return false;
        }
    };

    private DruidRules() {
    }

    private static boolean checkIsFlooringTimestampRefOnQuery(ImmutableBitSet set, RelNode top, DruidQuery query) {
        if (top instanceof Project) {
            ImmutableBitSet.Builder newSet = ImmutableBitSet.builder();
            Project project = (Project)top;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                RexNode node = (RexNode)project.getProjects().get(index);
                if (!(node instanceof RexCall)) continue;
                RexCall call = (RexCall)node;
                assert (DruidDateTimeUtils.extractGranularity((RexNode)call) != null);
                if (call.getKind() != SqlKind.FLOOR) continue;
                newSet.addAll(RelOptUtil.InputFinder.bits((RexNode)call));
            }
            top = project.getInput();
            set = newSet.build();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!query.druidTable.timestampFieldName.equals(top.getRowType().getFieldNames().get(index))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkTimestampRefOnQuery(ImmutableBitSet set, RelNode top, DruidQuery query) {
        if (top instanceof Project) {
            ImmutableBitSet.Builder newSet = ImmutableBitSet.builder();
            Project project = (Project)top;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                RexNode node = (RexNode)project.getProjects().get(index);
                if (node instanceof RexInputRef) {
                    newSet.set(((RexInputRef)node).getIndex());
                    continue;
                }
                if (!(node instanceof RexCall)) continue;
                RexCall call = (RexCall)node;
                assert (DruidDateTimeUtils.extractGranularity((RexNode)call) != null);
                newSet.addAll(RelOptUtil.InputFinder.bits((RexNode)call));
            }
            top = project.getInput();
            set = newSet.build();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!query.druidTable.timestampFieldName.equals(top.getRowType().getFieldNames().get(index))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAggregateOnMetric(ImmutableBitSet set, RelNode topProject, DruidQuery query) {
        if (topProject instanceof Project) {
            ImmutableBitSet.Builder newSet = ImmutableBitSet.builder();
            Project project = (Project)topProject;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                RexNode node = (RexNode)project.getProjects().get(index);
                ImmutableBitSet setOfBits = RelOptUtil.InputFinder.bits((RexNode)node);
                newSet.addAll(setOfBits);
            }
            set = newSet.build();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!query.druidTable.isMetric((String)query.getTopNode().getRowType().getFieldNames().get(index))) continue;
            return true;
        }
        return false;
    }

    public static class DruidFilterAggregateTransposeRule
    extends FilterAggregateTransposeRule {
        public DruidFilterAggregateTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterAggregateTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterAggregateTransposeRule.operand(Aggregate.class, (RelOptRuleOperand)DruidFilterAggregateTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterAggregateTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidAggregateFilterTransposeRule
    extends AggregateFilterTransposeRule {
        public DruidAggregateFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateFilterTransposeRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateFilterTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidAggregateFilterTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateFilterTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidFilterProjectTransposeRule
    extends FilterProjectTransposeRule {
        public DruidFilterProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterProjectTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidFilterProjectTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterProjectTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), true, true, relBuilderFactory);
        }
    }

    public static class DruidProjectFilterTransposeRule
    extends ProjectFilterTransposeRule {
        public DruidProjectFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectFilterTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidProjectFilterTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidProjectFilterTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectFilterTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), PushProjector.ExprCondition.FALSE, relBuilderFactory);
        }
    }

    public static class DruidSortRule
    extends RelOptRule {
        public DruidSortRule(RelBuilderFactory relBuilderFactory) {
            super(DruidSortRule.operand(Sort.class, (RelOptRuleOperand)DruidSortRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidSortRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'l')) {
                return;
            }
            if (!DruidSortRule.validSortLimit(sort, query)) {
                return;
            }
            Sort newSort = sort.copy(sort.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            call.transformTo((RelNode)DruidQuery.extendQuery(query, (RelNode)newSort));
        }

        private static boolean validSortLimit(Sort sort, DruidQuery query) {
            Aggregate topAgg;
            if (sort.offset != null && RexLiteral.intValue((RexNode)sort.offset) != 0) {
                return false;
            }
            RelNode topNode = query.getTopNode();
            if (topNode instanceof Project && ((Project)topNode).getInput() instanceof Aggregate) {
                topAgg = (Aggregate)((Project)topNode).getInput();
            } else if (topNode instanceof Aggregate) {
                topAgg = (Aggregate)topNode;
            } else {
                return RelOptUtil.isPureLimit((RelNode)sort);
            }
            ImmutableBitSet.Builder positionsReferenced = ImmutableBitSet.builder();
            for (RelFieldCollation col : sort.collation.getFieldCollations()) {
                int idx = col.getFieldIndex();
                if (idx >= topAgg.getGroupCount()) continue;
                positionsReferenced.set(topAgg.getGroupSet().nth(idx));
            }
            if (DruidRules.checkIsFlooringTimestampRefOnQuery(topAgg.getGroupSet(), topAgg.getInput(), query) && topAgg.getGroupCount() == 1) {
                return !RelOptUtil.isLimit((RelNode)sort) && sort.collation.getFieldCollations().size() == 1 && DruidRules.checkTimestampRefOnQuery(positionsReferenced.build(), topAgg.getInput(), query);
            }
            return true;
        }
    }

    public static class DruidProjectSortTransposeRule
    extends ProjectSortTransposeRule {
        public DruidProjectSortTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectSortTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidProjectSortTransposeRule.operand(Sort.class, (RelOptRuleOperand)DruidProjectSortTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectSortTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }
    }

    public static class DruidSortProjectTransposeRule
    extends SortProjectTransposeRule {
        public DruidSortProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidSortProjectTransposeRule.operand(Sort.class, (RelOptRuleOperand)DruidSortProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidSortProjectTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidSortProjectTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }
    }

    public static class DruidAggregateProjectRule
    extends RelOptRule {
        public DruidAggregateProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateProjectRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateProjectRule.operand(Project.class, (RelOptRuleOperand)DruidAggregateProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            DruidQuery query2;
            Aggregate aggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            DruidQuery query = (DruidQuery)call.rel(2);
            if (!DruidQuery.isValidSignature(query.signature() + 'p' + 'a')) {
                return;
            }
            int timestampIdx = DruidAggregateProjectRule.validProject(project, query);
            List<Integer> filterRefs = DruidAggregateProjectRule.getFilterRefs(aggregate.getAggCallList());
            if (timestampIdx == -1 && filterRefs.size() == 0) {
                return;
            }
            for (Integer i : filterRefs) {
                RexNode filterNode = (RexNode)project.getProjects().get(i);
                if (query.isValidFilter(filterNode, project.getInput()) && !filterNode.isAlwaysFalse()) continue;
                return;
            }
            if (aggregate.indicator || aggregate.getGroupSets().size() != 1 || BAD_AGG.apply((Object)ImmutableTriple.of((Object)aggregate, (Object)project, (Object)((Object)query))) || !DruidAggregateProjectRule.validAggregate(aggregate, timestampIdx, filterRefs.size())) {
                return;
            }
            if (DruidRules.checkAggregateOnMetric(aggregate.getGroupSet(), (RelNode)project, query)) {
                return;
            }
            RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), (List)ImmutableList.of((Object)newProject));
            if (filterRefs.size() > 0) {
                query2 = this.optimizeFilteredAggregations(call, query, (Project)newProject, (Aggregate)newAggregate);
            } else {
                DruidQuery query1 = DruidQuery.extendQuery(query, newProject);
                query2 = DruidQuery.extendQuery(query1, newAggregate);
            }
            call.transformTo((RelNode)query2);
        }

        private Set<Integer> getUniqueFilterRefs(List<AggregateCall> calls) {
            HashSet<Integer> refs = new HashSet<Integer>();
            for (AggregateCall call : calls) {
                if (!call.hasFilter()) continue;
                refs.add(call.filterArg);
            }
            return refs;
        }

        private DruidQuery optimizeFilteredAggregations(RelOptRuleCall call, DruidQuery query, Project project, Aggregate aggregate) {
            Filter filter = null;
            RexBuilder builder = query.getCluster().getRexBuilder();
            RexExecutor executor = (RexExecutor)Util.first((Object)query.getCluster().getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
            RelNode scan = (RelNode)query.rels.get(0);
            RelOptPredicateList predicates = call.getMetadataQuery().getPulledUpPredicates(scan);
            RexSimplify simplify = new RexSimplify(builder, predicates, true, executor);
            boolean containsFilter = false;
            for (RelNode node : query.rels) {
                if (!(node instanceof Filter)) continue;
                filter = (Filter)node;
                containsFilter = true;
                break;
            }
            boolean allHaveFilters = DruidAggregateProjectRule.allAggregatesHaveFilters(aggregate.getAggCallList());
            Set<Integer> uniqueFilterRefs = this.getUniqueFilterRefs(aggregate.getAggCallList());
            assert (uniqueFilterRefs.size() > 0);
            ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>();
            ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
            for (Object i : uniqueFilterRefs) {
                disjunctions.add(DruidAggregateProjectRule.stripFilter((RexNode)project.getProjects().get((Integer)i)));
            }
            RexNode filterNode = RexUtil.composeDisjunction((RexBuilder)builder, disjunctions);
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                int newFilterArg = aggCall.filterArg;
                if (!aggCall.hasFilter() || uniqueFilterRefs.size() == 1 && allHaveFilters || ((RexNode)project.getProjects().get(newFilterArg)).isAlwaysTrue()) {
                    newFilterArg = -1;
                }
                newCalls.add(aggCall.copy(aggCall.getArgList(), newFilterArg));
            }
            aggregate = aggregate.copy(aggregate.getTraitSet(), aggregate.getInput(), aggregate.indicator, aggregate.getGroupSet(), (List)aggregate.getGroupSets(), newCalls);
            if (containsFilter) {
                filterNode = builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{filterNode, filter.getCondition()});
            }
            RexNode tempFilterNode = filterNode;
            if ((filterNode = simplify.simplify(filterNode)).isAlwaysFalse()) {
                filterNode = tempFilterNode;
            }
            boolean addNewFilter = !(filter = LogicalFilter.create((RelNode)scan, (RexNode)filterNode)).getCondition().isAlwaysTrue() && allHaveFilters;
            int startIndex = containsFilter && addNewFilter ? 2 : 1;
            List<RelNode> newNodes = DruidAggregateProjectRule.constructNewNodes(query.rels, addNewFilter, startIndex, (RelNode)filter, new RelNode[]{project, aggregate});
            return DruidQuery.create(query.getCluster(), aggregate.getTraitSet().replace((RelTrait)query.getConvention()), query.getTable(), query.druidTable, newNodes);
        }

        private static boolean allAggregatesHaveFilters(List<AggregateCall> calls) {
            for (AggregateCall call : calls) {
                if (call.hasFilter()) continue;
                return false;
            }
            return true;
        }

        private static List<RelNode> constructNewNodes(List<RelNode> oldNodes, boolean addFilter, int startIndex, RelNode filter, RelNode ... trailingNodes) {
            ArrayList<RelNode> newNodes = new ArrayList<RelNode>();
            newNodes.add(oldNodes.get(0));
            if (addFilter) {
                newNodes.add(filter);
                if (startIndex < oldNodes.size()) {
                    RelNode next = oldNodes.get(startIndex);
                    newNodes.add(next.copy(next.getTraitSet(), Collections.singletonList(filter)));
                    ++startIndex;
                }
            }
            for (int i = startIndex; i < oldNodes.size(); ++i) {
                newNodes.add(oldNodes.get(i));
            }
            for (RelNode node : trailingNodes) {
                newNodes.add(node.copy(node.getTraitSet(), Collections.singletonList(Util.last(newNodes))));
            }
            return newNodes;
        }

        private static RexNode stripFilter(RexNode node) {
            if (node.getKind() == SqlKind.IS_TRUE) {
                return (RexNode)((RexCall)node).getOperands().get(0);
            }
            return node;
        }

        private static List<Integer> getFilterRefs(List<AggregateCall> calls) {
            ArrayList<Integer> refs = new ArrayList<Integer>();
            for (AggregateCall call : calls) {
                if (!call.hasFilter()) continue;
                refs.add(call.filterArg);
            }
            return refs;
        }

        private static int validProject(Project project, DruidQuery query) {
            List nodes = project.getProjects();
            int idxTimestamp = -1;
            boolean hasFloor = false;
            block4: for (int i = 0; i < nodes.size(); ++i) {
                RexNode e = (RexNode)nodes.get(i);
                if (e instanceof RexCall) {
                    RexCall call = (RexCall)e;
                    if (DruidDateTimeUtils.extractGranularity((RexNode)call) == null) {
                        return -1;
                    }
                    if (idxTimestamp != -1 && hasFloor) {
                        return -1;
                    }
                    switch (call.getKind()) {
                        case FLOOR: {
                            hasFloor = true;
                            if (!(call.getOperands().get(0) instanceof RexInputRef)) {
                                return -1;
                            }
                            RexInputRef ref = (RexInputRef)call.getOperands().get(0);
                            if (!DruidRules.checkTimestampRefOnQuery(ImmutableBitSet.of((int[])new int[]{ref.getIndex()}), query.getTopNode(), query)) {
                                return -1;
                            }
                            idxTimestamp = i;
                            continue block4;
                        }
                        case EXTRACT: {
                            idxTimestamp = (Integer)RelOptUtil.InputFinder.bits((RexNode)call).asList().get(0);
                            continue block4;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (!(e instanceof RexInputRef)) {
                    return -1;
                }
                RexInputRef ref = (RexInputRef)e;
                if (!DruidRules.checkTimestampRefOnQuery(ImmutableBitSet.of((int[])new int[]{ref.getIndex()}), query.getTopNode(), query)) continue;
                if (idxTimestamp != -1) {
                    return -1;
                }
                idxTimestamp = i;
            }
            return idxTimestamp;
        }

        private static boolean validAggregate(Aggregate aggregate, int idx, int numFilterRefs) {
            if (numFilterRefs > 0 && idx < 0) {
                return true;
            }
            if (!aggregate.getGroupSet().get(idx)) {
                return false;
            }
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                if (!aggCall.getArgList().contains(idx)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DruidAggregateRule
    extends RelOptRule {
        public DruidAggregateRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'a')) {
                return;
            }
            if (aggregate.indicator || aggregate.getGroupSets().size() != 1 || BAD_AGG.apply((Object)ImmutableTriple.of((Object)aggregate, (Object)aggregate, (Object)((Object)query))) || !DruidAggregateRule.validAggregate(aggregate, query)) {
                return;
            }
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            call.transformTo((RelNode)DruidQuery.extendQuery(query, newAggregate));
        }

        private static boolean validAggregate(Aggregate aggregate, DruidQuery query) {
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                builder.addAll((Iterable)aggCall.getArgList());
            }
            if (DruidRules.checkAggregateOnMetric(aggregate.getGroupSet(), (RelNode)aggregate, query)) {
                return false;
            }
            return !DruidRules.checkTimestampRefOnQuery(builder.build(), query.getTopNode(), query);
        }
    }

    public static class DruidPostAggregationProjectRule
    extends RelOptRule {
        public DruidPostAggregationProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidPostAggregationProjectRule.operand(Project.class, (RelOptRuleOperand)DruidPostAggregationProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidPostAggregationProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = project.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'o')) {
                return;
            }
            Pair<ImmutableMap<String, String>, Boolean> scanned = this.scanProject(query, project);
            if (((Boolean)scanned.right).booleanValue()) {
                Pair<Project, Project> splitProjectAggregate = this.splitProject(rexBuilder, query, project, (ImmutableMap<String, String>)((ImmutableMap)scanned.left), cluster);
                Project inner = (Project)splitProjectAggregate.left;
                Project outer = (Project)splitProjectAggregate.right;
                DruidQuery newQuery = DruidQuery.extendQuery(query, (RelNode)inner);
                if (outer != null) {
                    Project newProject = outer.copy(outer.getTraitSet(), (RelNode)newQuery, outer.getProjects(), outer.getRowType());
                    call.transformTo((RelNode)newProject);
                } else {
                    call.transformTo((RelNode)newQuery);
                }
            }
        }

        public Pair<Project, Project> splitProject(final RexBuilder rexBuilder, DruidQuery query, Project project, ImmutableMap<String, String> nameMap, RelOptCluster cluster) {
            ArrayList<Object> innerRex = new ArrayList<Object>();
            RelDataTypeFactory.FieldInfoBuilder typeBuilder = cluster.getTypeFactory().builder();
            RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
            final ArrayList<Integer> positions = new ArrayList<Integer>();
            final ArrayList<RelDataType> innerTypes = new ArrayList<RelDataType>();
            int offset = 0;
            for (Pair pair : project.getNamedProjects()) {
                RexNode rex = (RexNode)pair.left;
                String name = (String)pair.right;
                String fieldName = (String)nameMap.get((Object)name);
                if (fieldName == null) {
                    rex.accept((RexVisitor)visitor);
                    continue;
                }
                RexNode node = rexBuilder.copy(rex);
                innerRex.add(node);
                positions.add(offset++);
                typeBuilder.add((String)nameMap.get((Object)name), node.getType());
                innerTypes.add(node.getType());
            }
            positions.addAll(visitor.inputPosReferenced);
            Iterator iterator = visitor.inputPosReferenced.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                RexInputRef node = rexBuilder.makeInputRef((RelNode)Util.last(query.rels), i);
                innerRex.add(node);
                typeBuilder.add((String)query.getRowType().getFieldNames().get(i), node.getType());
                innerTypes.add(node.getType());
            }
            Project innerProject = project.copy(project.getTraitSet(), (RelNode)Util.last(query.rels), innerRex, typeBuilder.build());
            if (project.getNamedProjects().size() == nameMap.size()) {
                return new Pair((Object)innerProject, null);
            }
            offset = 0;
            ArrayList<Object> outerRex = new ArrayList<Object>();
            for (Pair pair : project.getNamedProjects()) {
                RexNode rex = (RexNode)pair.left;
                String name = (String)pair.right;
                if (!nameMap.containsKey((Object)name)) {
                    outerRex.add(rex.accept((RexVisitor)new RexShuttle(){

                        public RexNode visitInputRef(RexInputRef ref) {
                            int j = positions.indexOf(ref.getIndex());
                            return rexBuilder.makeInputRef((RelDataType)innerTypes.get(j), j);
                        }
                    }));
                    continue;
                }
                outerRex.add(rexBuilder.makeInputRef(rex.getType(), positions.indexOf(offset++)));
            }
            Project outerProject = project.copy(project.getTraitSet(), (RelNode)innerProject, outerRex, project.getRowType());
            return new Pair((Object)innerProject, (Object)outerProject);
        }

        public Pair<ImmutableMap<String, String>, Boolean> scanProject(DruidQuery query, Project project) {
            List aggNamesWithGroup = query.getRowType().getFieldNames();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            int j = 0;
            boolean ret = false;
            for (Pair namedProject : project.getNamedProjects()) {
                RexNode rex = (RexNode)namedProject.left;
                String name = (String)namedProject.right;
                if (rex instanceof RexCall) {
                    if (!this.checkPostAggregatorExist(rex)) continue;
                    String postAggName = "postagg#" + j++;
                    mapBuilder.put((Object)name, (Object)postAggName);
                    ret = true;
                    continue;
                }
                if (!(rex instanceof RexInputRef)) continue;
                String fieldName = (String)aggNamesWithGroup.get(((RexInputRef)rex).getIndex());
                mapBuilder.put((Object)name, (Object)fieldName);
            }
            return new Pair((Object)mapBuilder.build(), (Object)ret);
        }

        public boolean checkPostAggregatorExist(RexNode rexNode) {
            if (rexNode instanceof RexCall) {
                for (RexNode ele : ((RexCall)rexNode).getOperands()) {
                    boolean inputRex = this.checkPostAggregatorExist(ele);
                    if (inputRex) continue;
                    return false;
                }
                switch (rexNode.getKind()) {
                    case PLUS: 
                    case MINUS: 
                    case DIVIDE: 
                    case TIMES: {
                        return true;
                    }
                }
                return false;
            }
            return rexNode instanceof RexInputRef || rexNode instanceof RexLiteral;
        }
    }

    public static class DruidProjectRule
    extends RelOptRule {
        public DruidProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectRule.operand(Project.class, (RelOptRuleOperand)DruidProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = project.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'p')) {
                return;
            }
            if (DruidProjectRule.canProjectAll(project.getProjects())) {
                RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
                DruidQuery newNode = DruidQuery.extendQuery(query, newProject);
                call.transformTo((RelNode)newNode);
                return;
            }
            Pair<List<RexNode>, List<RexNode>> pair = DruidProjectRule.splitProjects(rexBuilder, (RelNode)query, project.getProjects());
            if (pair == null) {
                return;
            }
            List above = (List)pair.left;
            List below = (List)pair.right;
            RelDataTypeFactory.FieldInfoBuilder builder = cluster.getTypeFactory().builder();
            RelNode input = (RelNode)Util.last(query.rels);
            for (RexNode e : below) {
                String name = e instanceof RexInputRef ? (String)input.getRowType().getFieldNames().get(((RexInputRef)e).getIndex()) : null;
                builder.add(name, e.getType());
            }
            Project newProject = project.copy(project.getTraitSet(), input, below, builder.build());
            DruidQuery newQuery = DruidQuery.extendQuery(query, (RelNode)newProject);
            Project newProject2 = project.copy(project.getTraitSet(), (RelNode)newQuery, above, project.getRowType());
            call.transformTo((RelNode)newProject2);
        }

        private static boolean canProjectAll(List<RexNode> nodes) {
            for (RexNode e : nodes) {
                if (e instanceof RexInputRef) continue;
                return false;
            }
            return true;
        }

        private static Pair<List<RexNode>, List<RexNode>> splitProjects(final RexBuilder rexBuilder, RelNode input, List<RexNode> nodes) {
            RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
            for (RexNode node : nodes) {
                node.accept((RexVisitor)visitor);
            }
            if (visitor.inputPosReferenced.size() == input.getRowType().getFieldCount()) {
                return null;
            }
            ArrayList<RexInputRef> belowNodes = new ArrayList<RexInputRef>();
            final ArrayList<RelDataType> belowTypes = new ArrayList<RelDataType>();
            final ArrayList positions = Lists.newArrayList((Iterable)visitor.inputPosReferenced);
            Iterator iterator = positions.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                RexInputRef rexInputRef = rexBuilder.makeInputRef(input, i);
                belowNodes.add(rexInputRef);
                belowTypes.add(rexInputRef.getType());
            }
            ArrayList<Object> aboveNodes = new ArrayList<Object>();
            for (RexNode rexNode : nodes) {
                aboveNodes.add(rexNode.accept((RexVisitor)new RexShuttle(){

                    public RexNode visitInputRef(RexInputRef ref) {
                        int index = positions.indexOf(ref.getIndex());
                        return rexBuilder.makeInputRef((RelDataType)belowTypes.get(index), index);
                    }
                }));
            }
            return Pair.of(aboveNodes, belowNodes);
        }
    }

    public static class DruidFilterRule
    extends RelOptRule {
        public DruidFilterRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Triple<List<RexNode>, List<RexNode>, List<RexNode>> triple;
            Filter filter = (Filter)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = filter.getCluster();
            RelBuilder relBuilder = call.builder();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'f')) {
                return;
            }
            ArrayList<RexNode> validPreds = new ArrayList<RexNode>();
            ArrayList<RexNode> nonValidPreds = new ArrayList<RexNode>();
            RexExecutor executor = (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
            RelOptPredicateList predicates = call.getMetadataQuery().getPulledUpPredicates(filter.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, true, executor);
            RexNode cond = simplify.simplify(filter.getCondition());
            if (!DruidFilterRule.canPush(cond)) {
                return;
            }
            for (RexNode e : RelOptUtil.conjunctions((RexNode)cond)) {
                if (query.isValidFilter(e)) {
                    validPreds.add(e);
                    continue;
                }
                nonValidPreds.add(e);
            }
            int timestampFieldIdx = -1;
            for (int i = 0; i < query.getRowType().getFieldCount(); ++i) {
                if (!query.druidTable.timestampFieldName.equals(((RelDataTypeField)query.getRowType().getFieldList().get(i)).getName())) continue;
                timestampFieldIdx = i;
                break;
            }
            if (((List)(triple = DruidFilterRule.splitFilters(rexBuilder, query, validPreds, nonValidPreds, timestampFieldIdx)).getLeft()).isEmpty() && ((List)triple.getMiddle()).isEmpty()) {
                return;
            }
            ArrayList residualPreds = new ArrayList((Collection)triple.getRight());
            List<Interval> intervals = null;
            if (!((List)triple.getLeft()).isEmpty() && ((intervals = DruidDateTimeUtils.createInterval(RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)triple.getLeft()), (boolean)false), ((CalciteConnectionConfig)cluster.getPlanner().getContext().unwrap(CalciteConnectionConfig.class)).timeZone())) == null || intervals.isEmpty())) {
                ((List)triple.getMiddle()).addAll((Collection)triple.getLeft());
            }
            DruidQuery newDruidQuery = query;
            if (!((List)triple.getMiddle()).isEmpty()) {
                Filter newFilter = filter.copy(filter.getTraitSet(), (RelNode)Util.last(query.rels), RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)triple.getMiddle()), (boolean)false));
                newDruidQuery = DruidQuery.extendQuery(query, (RelNode)newFilter);
            }
            if (intervals != null && !intervals.isEmpty()) {
                newDruidQuery = DruidQuery.extendQuery(newDruidQuery, intervals);
            }
            if (!residualPreds.isEmpty()) {
                newDruidQuery = relBuilder.push((RelNode)newDruidQuery).filter(residualPreds).build();
            }
            call.transformTo((RelNode)newDruidQuery);
        }

        private static Triple<List<RexNode>, List<RexNode>, List<RexNode>> splitFilters(RexBuilder rexBuilder, DruidQuery input, List<RexNode> validPreds, List<RexNode> nonValidPreds, int timestampFieldIdx) {
            ArrayList<RexNode> timeRangeNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> pushableNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> nonPushableNodes = new ArrayList<RexNode>(nonValidPreds);
            for (RexNode conj : validPreds) {
                RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
                conj.accept((RexVisitor)visitor);
                if (visitor.inputPosReferenced.contains(timestampFieldIdx)) {
                    if (visitor.inputPosReferenced.size() != 1) {
                        nonPushableNodes.add(conj);
                        continue;
                    }
                    timeRangeNodes.add(conj);
                    continue;
                }
                boolean filterOnMetrics = false;
                for (Integer i : visitor.inputPosReferenced) {
                    if (!input.druidTable.isMetric(((RelDataTypeField)input.getRowType().getFieldList().get(i)).getName())) continue;
                    filterOnMetrics = true;
                    break;
                }
                if (filterOnMetrics) {
                    nonPushableNodes.add(conj);
                    continue;
                }
                pushableNodes.add(conj);
            }
            return ImmutableTriple.of(timeRangeNodes, pushableNodes, nonPushableNodes);
        }

        private static boolean canPush(RexNode cond) {
            return !cond.isAlwaysFalse();
        }
    }
}

