/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;

public class DruidDateTimeUtils {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    private DruidDateTimeUtils() {
    }

    public static List<Interval> createInterval(RexNode e, String timeZone) {
        List<Range<TimestampString>> ranges = DruidDateTimeUtils.extractRanges(e, TimeZone.getTimeZone(timeZone), false);
        if (ranges == null) {
            return null;
        }
        TreeRangeSet condensedRanges = TreeRangeSet.create();
        for (Range<TimestampString> r : ranges) {
            condensedRanges.add(r);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inferred ranges on interval : " + condensedRanges);
        }
        return DruidDateTimeUtils.toInterval((List<Range<TimestampString>>)ImmutableList.copyOf((Collection)condensedRanges.asRanges()));
    }

    protected static List<Interval> toInterval(List<Range<TimestampString>> ranges) {
        List intervals = Lists.transform(ranges, (Function)new Function<Range<TimestampString>, Interval>(){

            public Interval apply(Range<TimestampString> range) {
                long end;
                if (!range.hasLowerBound() && !range.hasUpperBound()) {
                    return DruidTable.DEFAULT_INTERVAL;
                }
                long start = range.hasLowerBound() ? ((TimestampString)range.lowerEndpoint()).getMillisSinceEpoch() : DruidTable.DEFAULT_INTERVAL.getStartMillis();
                long l = end = range.hasUpperBound() ? ((TimestampString)range.upperEndpoint()).getMillisSinceEpoch() : DruidTable.DEFAULT_INTERVAL.getEndMillis();
                if (range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN) {
                    ++start;
                }
                if (range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED) {
                    ++end;
                }
                return new Interval(start, end, (Chronology)ISOChronology.getInstanceUTC());
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converted time ranges " + ranges + " to interval " + intervals);
        }
        return intervals;
    }

    protected static List<Range<TimestampString>> extractRanges(RexNode node, TimeZone timeZone, boolean withNot) {
        switch (node.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN: 
            case IN: {
                return DruidDateTimeUtils.leafToRanges((RexCall)node, timeZone, withNot);
            }
            case NOT: {
                return DruidDateTimeUtils.extractRanges((RexNode)((RexCall)node).getOperands().get(0), timeZone, !withNot);
            }
            case OR: {
                RexCall call = (RexCall)node;
                ArrayList intervals = Lists.newArrayList();
                for (RexNode child : call.getOperands()) {
                    List<Range<TimestampString>> extracted = DruidDateTimeUtils.extractRanges(child, timeZone, withNot);
                    if (extracted == null) continue;
                    intervals.addAll(extracted);
                }
                return intervals;
            }
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<Object> ranges = new ArrayList<Range<TimestampString>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<TimestampString>> extractedRanges = DruidDateTimeUtils.extractRanges(child, timeZone, false);
                    if (extractedRanges == null || extractedRanges.isEmpty()) {
                        return null;
                    }
                    if (ranges.isEmpty()) {
                        ranges.addAll(extractedRanges);
                        continue;
                    }
                    ArrayList<Range> overlapped = new ArrayList<Range>();
                    for (Range range : ranges) {
                        for (Range<TimestampString> interval : extractedRanges) {
                            if (!range.isConnected(interval)) continue;
                            overlapped.add(range.intersection(interval));
                        }
                    }
                    ranges = overlapped;
                }
                return ranges;
            }
        }
        return null;
    }

    protected static List<Range<TimestampString>> leafToRanges(RexCall call, TimeZone timeZone, boolean withNot) {
        switch (call.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                TimestampString value;
                if (call.getOperands().get(0) instanceof RexInputRef && DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(1), timeZone) != null) {
                    value = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(1), timeZone);
                } else if (call.getOperands().get(1) instanceof RexInputRef && DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(0), timeZone) != null) {
                    value = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(0), timeZone);
                } else {
                    return null;
                }
                switch (call.getKind()) {
                    case LESS_THAN: {
                        return ImmutableList.of((Object)(withNot ? Range.atLeast((Comparable)value) : Range.lessThan((Comparable)value)));
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ImmutableList.of((Object)(withNot ? Range.greaterThan((Comparable)value) : Range.atMost((Comparable)value)));
                    }
                    case GREATER_THAN: {
                        return ImmutableList.of((Object)(withNot ? Range.atMost((Comparable)value) : Range.greaterThan((Comparable)value)));
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ImmutableList.of((Object)(withNot ? Range.lessThan((Comparable)value) : Range.atLeast((Comparable)value)));
                    }
                }
                if (!withNot) {
                    return ImmutableList.of((Object)Range.closed((Comparable)value, (Comparable)value));
                }
                return ImmutableList.of((Object)Range.lessThan((Comparable)value), (Object)Range.greaterThan((Comparable)value));
            }
            case BETWEEN: {
                boolean inverted;
                if (DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(2), timeZone) == null || DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(3), timeZone) == null) {
                    return null;
                }
                TimestampString value1 = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(2), timeZone);
                TimestampString value2 = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(3), timeZone);
                boolean bl = inverted = value1.compareTo(value2) > 0;
                if (!withNot) {
                    return ImmutableList.of((Object)(inverted ? Range.closed((Comparable)value2, (Comparable)value1) : Range.closed((Comparable)value1, (Comparable)value2)));
                }
                return ImmutableList.of((Object)Range.lessThan((Comparable)(inverted ? value2 : value1)), (Object)Range.greaterThan((Comparable)(inverted ? value1 : value2)));
            }
            case IN: {
                ImmutableList.Builder ranges = ImmutableList.builder();
                for (RexNode operand : Util.skip((List)call.operands)) {
                    TimestampString element = DruidDateTimeUtils.literalValue(operand, timeZone);
                    if (element == null) {
                        return null;
                    }
                    if (withNot) {
                        ranges.add((Object)Range.lessThan((Comparable)element));
                        ranges.add((Object)Range.greaterThan((Comparable)element));
                        continue;
                    }
                    ranges.add((Object)Range.closed((Comparable)element, (Comparable)element));
                }
                return ranges.build();
            }
        }
        return null;
    }

    private static TimestampString literalValue(RexNode node, TimeZone timeZone) {
        switch (node.getKind()) {
            case LITERAL: {
                switch (((RexLiteral)node).getTypeName()) {
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        return (TimestampString)((RexLiteral)node).getValueAs(TimestampString.class);
                    }
                    case TIMESTAMP: {
                        TimestampString t = (TimestampString)((RexLiteral)node).getValueAs(TimestampString.class);
                        return new TimestampWithTimeZoneString(t.toString() + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString();
                    }
                    case DATE: {
                        DateString d = (DateString)((RexLiteral)node).getValueAs(DateString.class);
                        return new TimestampWithTimeZoneString(TimestampString.fromMillisSinceEpoch((long)d.getMillisSinceEpoch()).toString() + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString();
                    }
                }
                break;
            }
            case CAST: {
                assert (node instanceof RexCall);
                RexCall call = (RexCall)node;
                RexNode operand = (RexNode)call.getOperands().get(0);
                RelDataType callType = call.getType();
                RelDataType operandType = operand.getType();
                if (operand.getKind() != SqlKind.LITERAL || callType.getSqlTypeName() != operandType.getSqlTypeName() || callType.getSqlTypeName() != SqlTypeName.DATE && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE || !callType.isNullable() || operandType.isNullable()) break;
                return DruidDateTimeUtils.literalValue(operand, timeZone);
            }
        }
        return null;
    }

    public static Granularity extractGranularity(RexNode node) {
        int flagIndex;
        switch (node.getKind()) {
            case EXTRACT: {
                flagIndex = 0;
                break;
            }
            case FLOOR: {
                flagIndex = 1;
                break;
            }
            default: {
                return null;
            }
        }
        RexCall call = (RexCall)node;
        if (call.operands.size() != 2) {
            return null;
        }
        RexLiteral flag = (RexLiteral)call.operands.get(flagIndex);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case YEAR: {
                return Granularity.YEAR;
            }
            case QUARTER: {
                return Granularity.QUARTER;
            }
            case MONTH: {
                return Granularity.MONTH;
            }
            case WEEK: {
                return Granularity.WEEK;
            }
            case DAY: {
                return Granularity.DAY;
            }
            case HOUR: {
                return Granularity.HOUR;
            }
            case MINUTE: {
                return Granularity.MINUTE;
            }
            case SECOND: {
                return Granularity.SECOND;
            }
        }
        return null;
    }
}

