/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import java.net.UnknownHostException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.jmx.BKMBeanInfo;
import org.apache.bookkeeper.proto.BKStats;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.BookieServerMXBean;
import org.apache.bookkeeper.proto.ServerStats;
import org.apache.bookkeeper.util.StringUtils;

public class BookieServerBean
implements BookieServerMXBean,
BKMBeanInfo {
    protected final BookieServer bks;
    protected final ServerConfiguration conf;
    private final String name;

    public BookieServerBean(ServerConfiguration conf, BookieServer bks) {
        this.conf = conf;
        this.bks = bks;
        this.name = "BookieServer_" + conf.getBookiePort();
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return false;
    }

    @Override
    public long getNumPacketsReceived() {
        return ServerStats.getInstance().getPacketsReceived();
    }

    @Override
    public long getNumPacketsSent() {
        return ServerStats.getInstance().getPacketsSent();
    }

    @Override
    public BKStats.OpStatData getAddStats() {
        return this.bks.bkStats.getOpStats(0).toOpStatData();
    }

    @Override
    public BKStats.OpStatData getReadStats() {
        return this.bks.bkStats.getOpStats(1).toOpStatData();
    }

    @Override
    public String getServerPort() {
        try {
            return StringUtils.addrToString(Bookie.getBookieAddress(this.conf));
        }
        catch (UnknownHostException e) {
            return "localhost:" + this.conf.getBookiePort();
        }
    }
}

