/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.commons.lang.StringUtils;

public class ServerConfiguration
extends AbstractConfiguration {
    protected static final String ENTRY_LOG_SIZE_LIMIT = "logSizeLimit";
    protected static final String MINOR_COMPACTION_INTERVAL = "minorCompactionInterval";
    protected static final String MINOR_COMPACTION_THRESHOLD = "minorCompactionThreshold";
    protected static final String MAJOR_COMPACTION_INTERVAL = "majorCompactionInterval";
    protected static final String MAJOR_COMPACTION_THRESHOLD = "majorCompactionThreshold";
    protected static final String COMPACTION_MAX_OUTSTANDING_REQUESTS = "compactionMaxOutstandingRequests";
    protected static final String COMPACTION_RATE = "compactionRate";
    protected static final String GC_WAIT_TIME = "gcWaitTime";
    protected static final String FLUSH_INTERVAL = "flushInterval";
    protected static final String DEATH_WATCH_INTERVAL = "bookieDeathWatchInterval";
    protected static final String OPEN_FILE_LIMIT = "openFileLimit";
    protected static final String PAGE_LIMIT = "pageLimit";
    protected static final String PAGE_SIZE = "pageSize";
    protected static final String MAX_JOURNAL_SIZE = "journalMaxSizeMB";
    protected static final String MAX_BACKUP_JOURNALS = "journalMaxBackups";
    protected static final String BOOKIE_PORT = "bookiePort";
    protected static final String LISTENING_INTERFACE = "listeningInterface";
    protected static final String ALLOW_LOOPBACK = "allowLoopback";
    protected static final String JOURNAL_DIR = "journalDirectory";
    protected static final String LEDGER_DIRS = "ledgerDirectories";
    protected static final String SERVER_TCP_NODELAY = "serverTcpNoDelay";
    protected static final String ZK_TIMEOUT = "zkTimeout";
    protected static final String ZK_SERVERS = "zkServers";
    protected static final String ENABLE_STATISTICS = "enableStatistics";
    protected static final String OPEN_LEDGER_REREPLICATION_GRACE_PERIOD = "openLedgerRereplicationGracePeriod";
    protected static final String READ_ONLY_MODE_ENABLED = "readOnlyModeEnabled";
    protected static final String DISK_USAGE_THRESHOLD = "diskUsageThreshold";
    protected static final String DISK_CHECK_INTERVAL = "diskCheckInterval";
    protected static final String AUDITOR_PERIODIC_CHECK_INTERVAL = "auditorPeriodicCheckInterval";
    protected static final String AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL = "auditorPeriodicBookieCheckInterval";
    protected static final String AUTO_RECOVERY_DAEMON_ENABLED = "autoRecoveryDaemonEnabled";

    public ServerConfiguration() {
    }

    public ServerConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public long getEntryLogSizeLimit() {
        return this.getLong(ENTRY_LOG_SIZE_LIMIT, 0x80000000L);
    }

    public ServerConfiguration setEntryLogSizeLimit(long logSizeLimit) {
        this.setProperty(ENTRY_LOG_SIZE_LIMIT, Long.toString(logSizeLimit));
        return this;
    }

    public long getGcWaitTime() {
        return this.getLong(GC_WAIT_TIME, 1000L);
    }

    public ServerConfiguration setGcWaitTime(long gcWaitTime) {
        this.setProperty(GC_WAIT_TIME, Long.toString(gcWaitTime));
        return this;
    }

    public int getFlushInterval() {
        return this.getInt(FLUSH_INTERVAL, 100);
    }

    public ServerConfiguration setFlushInterval(int flushInterval) {
        this.setProperty(FLUSH_INTERVAL, Integer.toString(flushInterval));
        return this;
    }

    public int getDeathWatchInterval() {
        return this.getInt(DEATH_WATCH_INTERVAL, 1000);
    }

    public int getOpenFileLimit() {
        return this.getInt(OPEN_FILE_LIMIT, 900);
    }

    public ServerConfiguration setOpenFileLimit(int fileLimit) {
        this.setProperty(OPEN_FILE_LIMIT, fileLimit);
        return this;
    }

    public int getPageLimit() {
        return this.getInt(PAGE_LIMIT, -1);
    }

    public ServerConfiguration setPageLimit(int pageLimit) {
        this.setProperty(PAGE_LIMIT, pageLimit);
        return this;
    }

    public int getPageSize() {
        return this.getInt(PAGE_SIZE, 8192);
    }

    public ServerConfiguration setPageSize(int pageSize) {
        this.setProperty(PAGE_SIZE, pageSize);
        return this;
    }

    public long getMaxJournalSize() {
        return this.getLong(MAX_JOURNAL_SIZE, 2048L);
    }

    public ServerConfiguration setMaxJournalSize(long maxJournalSize) {
        this.setProperty(MAX_JOURNAL_SIZE, Long.toString(maxJournalSize));
        return this;
    }

    public int getMaxBackupJournals() {
        return this.getInt(MAX_BACKUP_JOURNALS, 5);
    }

    public ServerConfiguration setMaxBackupJournals(int maxBackupJournals) {
        this.setProperty(MAX_BACKUP_JOURNALS, Integer.toString(maxBackupJournals));
        return this;
    }

    public int getBookiePort() {
        return this.getInt(BOOKIE_PORT, 3181);
    }

    public ServerConfiguration setBookiePort(int port) {
        this.setProperty(BOOKIE_PORT, Integer.toString(port));
        return this;
    }

    public String getListeningInterface() {
        return this.getString(LISTENING_INTERFACE);
    }

    public ServerConfiguration setListeningInterface(String iface) {
        this.setProperty(LISTENING_INTERFACE, iface);
        return this;
    }

    public boolean getAllowLoopback() {
        return this.getBoolean(ALLOW_LOOPBACK, false);
    }

    public ServerConfiguration setAllowLoopback(boolean allow) {
        this.setProperty(ALLOW_LOOPBACK, allow);
        return this;
    }

    public String getJournalDirName() {
        return this.getString(JOURNAL_DIR, "/tmp/bk-txn");
    }

    public ServerConfiguration setJournalDirName(String journalDir) {
        this.setProperty(JOURNAL_DIR, journalDir);
        return this;
    }

    public File getJournalDir() {
        String journalDirName = this.getJournalDirName();
        if (null == journalDirName) {
            return null;
        }
        return new File(journalDirName);
    }

    public String[] getLedgerDirNames() {
        String[] ledgerDirs = this.getStringArray(LEDGER_DIRS);
        if (null == ledgerDirs) {
            return new String[]{"/tmp/bk-data"};
        }
        return ledgerDirs;
    }

    public ServerConfiguration setLedgerDirNames(String[] ledgerDirs) {
        if (null == ledgerDirs) {
            return this;
        }
        this.setProperty(LEDGER_DIRS, ledgerDirs);
        return this;
    }

    public File[] getLedgerDirs() {
        String[] ledgerDirNames = this.getLedgerDirNames();
        if (null == ledgerDirNames) {
            return null;
        }
        File[] ledgerDirs = new File[ledgerDirNames.length];
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            ledgerDirs[i] = new File(ledgerDirNames[i]);
        }
        return ledgerDirs;
    }

    public boolean getServerTcpNoDelay() {
        return this.getBoolean(SERVER_TCP_NODELAY, true);
    }

    public ServerConfiguration setServerTcpNoDelay(boolean noDelay) {
        this.setProperty(SERVER_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public String getZkServers() {
        List servers = this.getList(ZK_SERVERS, null);
        if (null == servers || 0 == servers.size()) {
            return null;
        }
        return StringUtils.join((Collection)servers, (String)",");
    }

    public ServerConfiguration setZkServers(String zkServers) {
        this.setProperty(ZK_SERVERS, zkServers);
        return this;
    }

    public int getZkTimeout() {
        return this.getInt(ZK_TIMEOUT, 10000);
    }

    public ServerConfiguration setZkTimeout(int zkTimeout) {
        this.setProperty(ZK_TIMEOUT, Integer.toString(zkTimeout));
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.getBoolean(ENABLE_STATISTICS, true);
    }

    public ServerConfiguration setStatisticsEnabled(boolean enabled) {
        this.setProperty(ENABLE_STATISTICS, Boolean.toString(enabled));
        return this;
    }

    public double getMinorCompactionThreshold() {
        return this.getDouble(MINOR_COMPACTION_THRESHOLD, 0.2f);
    }

    public ServerConfiguration setMinorCompactionThreshold(double threshold) {
        this.setProperty(MINOR_COMPACTION_THRESHOLD, threshold);
        return this;
    }

    public double getMajorCompactionThreshold() {
        return this.getDouble(MAJOR_COMPACTION_THRESHOLD, 0.8f);
    }

    public ServerConfiguration setMajorCompactionThreshold(double threshold) {
        this.setProperty(MAJOR_COMPACTION_THRESHOLD, threshold);
        return this;
    }

    public long getMinorCompactionInterval() {
        return this.getLong(MINOR_COMPACTION_INTERVAL, 3600L);
    }

    public ServerConfiguration setMinorCompactionInterval(long interval) {
        this.setProperty(MINOR_COMPACTION_INTERVAL, interval);
        return this;
    }

    public long getMajorCompactionInterval() {
        return this.getLong(MAJOR_COMPACTION_INTERVAL, 86400L);
    }

    public ServerConfiguration setMajorCompactionInterval(long interval) {
        this.setProperty(MAJOR_COMPACTION_INTERVAL, interval);
        return this;
    }

    public void setOpenLedgerRereplicationGracePeriod(String waitTime) {
        this.setProperty(OPEN_LEDGER_REREPLICATION_GRACE_PERIOD, waitTime);
    }

    public long getOpenLedgerRereplicationGracePeriod() {
        return this.getLong(OPEN_LEDGER_REREPLICATION_GRACE_PERIOD, 30000L);
    }

    public ServerConfiguration setReadOnlyModeEnabled(boolean enabled) {
        this.setProperty(READ_ONLY_MODE_ENABLED, enabled);
        return this;
    }

    public boolean isReadOnlyModeEnabled() {
        return this.getBoolean(READ_ONLY_MODE_ENABLED, false);
    }

    public ServerConfiguration setDiskUsageThreshold(float threshold) {
        this.setProperty(DISK_USAGE_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskUsageThreshold() {
        return this.getFloat(DISK_USAGE_THRESHOLD, 0.95f);
    }

    public ServerConfiguration setDiskCheckInterval(int interval) {
        this.setProperty(DISK_CHECK_INTERVAL, interval);
        return this;
    }

    public int getDiskCheckInterval() {
        return this.getInt(DISK_CHECK_INTERVAL, 10000);
    }

    public void setAuditorPeriodicCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_CHECK_INTERVAL, 604800L);
    }

    public void setAuditorPeriodicBookieCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicBookieCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL, 86400L);
    }

    public ServerConfiguration setAutoRecoveryDaemonEnabled(boolean enabled) {
        this.setProperty(AUTO_RECOVERY_DAEMON_ENABLED, enabled);
        return this;
    }

    public boolean isAutoRecoveryDaemonEnabled() {
        return this.getBoolean(AUTO_RECOVERY_DAEMON_ENABLED, false);
    }

    public int getCompactionMaxOutstandingRequests() {
        return this.getInt(COMPACTION_MAX_OUTSTANDING_REQUESTS, 100000);
    }

    public ServerConfiguration setCompactionMaxOutstandingRequests(int maxOutstandingRequests) {
        this.setProperty(COMPACTION_MAX_OUTSTANDING_REQUESTS, maxOutstandingRequests);
        return this;
    }

    public int getCompactionRate() {
        return this.getInt(COMPACTION_RATE, 1000);
    }

    public ServerConfiguration setCompactionRate(int rate) {
        this.setProperty(COMPACTION_RATE, rate);
        return this;
    }
}

