/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.net.URL;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguration
extends CompositeConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(AbstractConfiguration.class);
    private static ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
    protected static final String LEDGER_MANAGER_TYPE = "ledgerManagerType";
    protected static final String LEDGER_MANAGER_FACTORY_CLASS = "ledgerManagerFactoryClass";
    protected static final String ZK_LEDGERS_ROOT_PATH = "zkLedgersRootPath";
    protected static final String AVAILABLE_NODE = "available";
    protected static final String REREPLICATION_ENTRY_BATCH_SIZE = "rereplicationEntryBatchSize";
    protected static final String METASTORE_IMPL_CLASS = "metastoreImplClass";
    protected static final String METASTORE_MAX_ENTRIES_PER_SCAN = "metastoreMaxEntriesPerScan";

    protected AbstractConfiguration() {
        this.addConfiguration((Configuration)new SystemConfiguration());
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        this.addConfiguration((Configuration)loadedConf);
    }

    public void loadConf(AbstractConfiguration baseConf) {
        this.addConfiguration((Configuration)baseConf);
    }

    public void loadConf(Configuration otherConf) {
        this.addConfiguration(otherConf);
    }

    @Deprecated
    public void setLedgerManagerType(String lmType) {
        this.setProperty(LEDGER_MANAGER_TYPE, lmType);
    }

    @Deprecated
    public String getLedgerManagerType() {
        return this.getString(LEDGER_MANAGER_TYPE);
    }

    public void setLedgerManagerFactoryClassName(String factoryClassName) {
        this.setProperty(LEDGER_MANAGER_FACTORY_CLASS, factoryClassName);
    }

    public void setLedgerManagerFactoryClass(Class<? extends LedgerManagerFactory> factoryClass) {
        this.setProperty(LEDGER_MANAGER_FACTORY_CLASS, factoryClass.getName());
    }

    public Class<? extends LedgerManagerFactory> getLedgerManagerFactoryClass() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, LEDGER_MANAGER_FACTORY_CLASS, null, LedgerManagerFactory.class, defaultLoader);
    }

    public void setZkLedgersRootPath(String zkLedgersPath) {
        this.setProperty(ZK_LEDGERS_ROOT_PATH, zkLedgersPath);
    }

    public String getZkLedgersRootPath() {
        return this.getString(ZK_LEDGERS_ROOT_PATH, "/ledgers");
    }

    public String getZkAvailableBookiesPath() {
        return this.getZkLedgersRootPath() + "/" + AVAILABLE_NODE;
    }

    public void setRereplicationEntryBatchSize(long rereplicationEntryBatchSize) {
        this.setProperty(REREPLICATION_ENTRY_BATCH_SIZE, rereplicationEntryBatchSize);
    }

    public long getRereplicationEntryBatchSize() {
        return this.getLong(REREPLICATION_ENTRY_BATCH_SIZE, 10L);
    }

    public String getMetastoreImplClass() {
        return this.getString(METASTORE_IMPL_CLASS);
    }

    public void setMetastoreImplClass(String metastoreImplClass) {
        this.setProperty(METASTORE_IMPL_CLASS, metastoreImplClass);
    }

    public int getMetastoreMaxEntriesPerScan() {
        return this.getInt(METASTORE_MAX_ENTRIES_PER_SCAN, 50);
    }

    public void setMetastoreMaxEntriesPerScan(int maxEntries) {
        this.setProperty(METASTORE_MAX_ENTRIES_PER_SCAN, maxEntries);
    }

    static {
        if (null == defaultLoader) {
            defaultLoader = AbstractConfiguration.class.getClassLoader();
        }
    }
}

