/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;

public class ReadOnlyEntryLogger
extends EntryLogger {
    public ReadOnlyEntryLogger(ServerConfiguration conf) throws IOException {
        super(conf, new LedgerDirsManager(conf));
    }

    @Override
    protected void initialize() throws IOException {
    }

    @Override
    void createNewLog() throws IOException {
        throw new IOException("Can't create new entry log using a readonly entry logger.");
    }

    @Override
    protected boolean removeEntryLog(long entryLogId) {
        return false;
    }

    @Override
    synchronized long addEntry(long ledger, ByteBuffer entry) throws IOException {
        throw new IOException("Can't add entry to a readonly entry logger.");
    }
}

