/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.Configuration;
import alluxio.hadoop.ConfUtils;
import org.junit.Assert;
import org.junit.Test;

public final class ConfUtilsTest {
    private static final String TEST_S3_ACCCES_KEY = "TEST ACCESS KEY";
    private static final String TEST_S3_SECRET_KEY = "TEST SECRET KEY";
    private static final String TEST_WORKER_MEMORY_SIZE = Integer.toString(654321);

    @Test
    public void loadFromEmptyHadoopConfigurationTest() {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        Configuration configuration = ConfUtils.loadFromHadoopConfiguration((org.apache.hadoop.conf.Configuration)hadoopConfig);
        Assert.assertEquals((long)0L, (long)configuration.toMap().size());
    }

    @Test
    public void loadFromHadoopConfigurationTest() {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        hadoopConfig.set("fs.s3n.awsAccessKeyId", TEST_S3_ACCCES_KEY);
        hadoopConfig.set("fs.s3n.awsSecretAccessKey", TEST_S3_SECRET_KEY);
        hadoopConfig.set("alluxio.worker.memory.size", TEST_WORKER_MEMORY_SIZE);
        hadoopConfig.set("hadoop.config.parameter", "hadoop config value");
        Configuration configuration = ConfUtils.loadFromHadoopConfiguration((org.apache.hadoop.conf.Configuration)hadoopConfig);
        Assert.assertEquals((long)3L, (long)configuration.toMap().size());
        Assert.assertEquals((Object)TEST_S3_ACCCES_KEY, (Object)configuration.get("fs.s3n.awsAccessKeyId"));
        Assert.assertEquals((Object)TEST_S3_SECRET_KEY, (Object)configuration.get("fs.s3n.awsSecretAccessKey"));
        Assert.assertEquals((Object)TEST_WORKER_MEMORY_SIZE, (Object)configuration.get("alluxio.worker.memory.size"));
    }
}

