/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.CommonTestUtils;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.lineage.LineageContext;
import alluxio.client.util.ClientTestUtils;
import alluxio.hadoop.FaultTolerantFileSystem;
import alluxio.hadoop.FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FileSystemContext.class, FileSystemMasterClient.class, UserGroupInformation.class})
@PowerMockIgnore(value={"javax.security.*"})
public class AbstractFileSystemTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private FileSystemContext mMockFileSystemContext;

    @Before
    public void setup() throws Exception {
        this.mockUserGroupInformation();
        this.mockMasterClient();
        if (this.isHadoop1x()) {
            LOG.debug("Running TFS tests against hadoop 1x");
        } else if (this.isHadoop2x()) {
            LOG.debug("Running TFS tests against hadoop 2x");
        } else {
            LOG.warn("Running TFS tests against untargeted Hadoop version: " + this.getHadoopVersion());
        }
    }

    private ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof MockClassLoader) {
            cl = cl.getParent();
        }
        return cl;
    }

    private String getHadoopVersion() {
        try {
            URL url = this.getSourcePath(org.apache.hadoop.fs.FileSystem.class);
            File path = new File(url.toURI());
            String[] splits = path.getName().split("-");
            String last = splits[splits.length - 1];
            return last.substring(0, last.lastIndexOf("."));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private URL getSourcePath(Class<?> clazz) {
        try {
            clazz = this.getClassLoader(clazz).loadClass(clazz.getName());
            return clazz.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Unable to find class " + clazz.getName()));
        }
    }

    @Test
    public void hadoopShouldLoadFaultTolerantFileSystemWhenConfiguredTest() throws IOException {
        Configuration conf = new Configuration();
        if (this.isHadoop1x()) {
            conf.set("fs.alluxio-ft.impl", FaultTolerantFileSystem.class.getName());
        }
        URI uri = URI.create("alluxio-ft://localhost:19998/tmp/path.txt");
        ClientContext.getConf().set("alluxio.master.hostname", uri.getHost());
        ClientContext.getConf().set("alluxio.master.port", Integer.toString(uri.getPort()));
        ClientContext.getConf().set("alluxio.zookeeper.enabled", "true");
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertTrue((boolean)(fs instanceof FaultTolerantFileSystem));
        PowerMockito.verifyStatic();
        FileSystem.Factory.get();
        ClientTestUtils.resetClientContext();
    }

    @Test
    public void hadoopShouldLoadFileSystemWhenConfiguredTest() throws IOException {
        Configuration conf = new Configuration();
        if (this.isHadoop1x()) {
            conf.set("fs.alluxio.impl", FileSystem.class.getName());
        }
        URI uri = URI.create("alluxio://localhost:19998/tmp/path.txt");
        ClientContext.getConf().set("alluxio.master.hostname", uri.getHost());
        ClientContext.getConf().set("alluxio.master.port", Integer.toString(uri.getPort()));
        ClientContext.getConf().set("alluxio.zookeeper.enabled", "false");
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertTrue((boolean)(fs instanceof FileSystem));
        PowerMockito.verifyStatic();
        FileSystem.Factory.get();
        ClientTestUtils.resetClientContext();
    }

    @Test
    public void resetContextTest() throws Exception {
        URI uri = URI.create("alluxio://localhost:19998/");
        Configuration conf = new Configuration();
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        URI newUri = URI.create("alluxio://otherhost:410/");
        fs.initialize(newUri, conf);
        InetSocketAddress newAddress = new InetSocketAddress("otherhost", 410);
        Assert.assertEquals((Object)newAddress, (Object)ClientContext.getMasterAddress());
        Assert.assertEquals((Object)newAddress, (Object)CommonTestUtils.getInternalState((Object)BlockStoreContext.INSTANCE, (String[])new String[]{"mBlockMasterClientPool", "mMasterAddress"}));
        ((FileSystemContext)Mockito.verify((Object)this.mMockFileSystemContext, (VerificationMode)Mockito.times((int)2))).reset();
        Assert.assertEquals((Object)newAddress, (Object)CommonTestUtils.getInternalState((Object)LineageContext.INSTANCE, (String[])new String[]{"mLineageMasterClientPool", "mMasterAddress"}));
    }

    private boolean isHadoop1x() {
        return this.getHadoopVersion().startsWith("1");
    }

    private boolean isHadoop2x() {
        return this.getHadoopVersion().startsWith("2");
    }

    private void mockMasterClient() {
        PowerMockito.mockStatic(FileSystemContext.class, (Class[])new Class[0]);
        this.mMockFileSystemContext = (FileSystemContext)PowerMockito.mock(FileSystemContext.class);
        FileSystemMasterClient mockMaster = (FileSystemMasterClient)PowerMockito.mock(FileSystemMasterClient.class);
        Whitebox.setInternalState(FileSystemContext.class, (String)"INSTANCE", (Object)this.mMockFileSystemContext);
        Mockito.when((Object)this.mMockFileSystemContext.acquireMasterClient()).thenReturn((Object)mockMaster);
    }

    private void mockUserGroupInformation() throws IOException {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn((Object)ugi);
    }
}

