/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.util;

import alluxio.client.ClientContext;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.file.FileSystemContext;
import alluxio.client.lineage.LineageContext;
import com.google.common.base.Throwables;
import org.powermock.reflect.Whitebox;

public final class ClientTestUtils {
    public static void setSmallBufferSizes() {
        ClientContext.getConf().set("alluxio.user.block.remote.read.buffer.size.bytes", "4KB");
        ClientContext.getConf().set("alluxio.user.file.buffer.bytes", "4KB");
    }

    public static void resetClientContext() {
        try {
            Whitebox.invokeMethod(ClientContext.class, (String)"reset", (Object[])new Object[0]);
            ClientTestUtils.resetContexts();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void reinitializeClientContext() {
        try {
            Whitebox.invokeMethod(ClientContext.class, (String)"init", (Object[])new Object[0]);
            ClientTestUtils.resetContexts();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void resetContexts() {
        BlockStoreContext.INSTANCE.reset();
        FileSystemContext.INSTANCE.reset();
        LineageContext.INSTANCE.reset();
    }
}

