/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.netty;

import alluxio.client.netty.ClientHandler;
import alluxio.exception.ExceptionMessage;
import alluxio.network.protocol.RPCBlockReadRequest;
import alluxio.network.protocol.RPCBlockReadResponse;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import alluxio.network.protocol.databuffer.DataBuffer;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ClientHandlerTest {
    private ClientHandler mHandler;
    private ChannelHandlerContext mContext;
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();

    @Before
    public void before() {
        this.mHandler = new ClientHandler();
        this.mContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    }

    @Test
    public void addListenerTest() {
        this.mThrown.expect(NullPointerException.class);
        this.mHandler.addListener(null);
    }

    @Test
    public void channelRead0ResponseReceivedTest() throws IOException {
        ClientHandler.ResponseListener listener = (ClientHandler.ResponseListener)Mockito.mock(ClientHandler.ResponseListener.class);
        DataBuffer buffer = (DataBuffer)Mockito.mock(DataBuffer.class);
        RPCBlockReadResponse response = new RPCBlockReadResponse(0L, 0L, 0L, buffer, RPCResponse.Status.SUCCESS);
        this.mHandler.addListener(listener);
        this.mHandler.channelRead0(this.mContext, (RPCMessage)response);
        ((ClientHandler.ResponseListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onResponseReceived((RPCResponse)response);
    }

    @Test
    public void channelRead0ThrowsExceptionTest() throws IOException {
        RPCBlockReadRequest message = new RPCBlockReadRequest(0L, 0L, 0L, 0L, 0L);
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.NO_RPC_HANDLER.getMessage(new Object[]{message.getType()}));
        this.mHandler.channelRead0(this.mContext, (RPCMessage)message);
    }

    @Test
    public void exceptionCaughtClosesContextTest() throws Exception {
        this.mHandler.exceptionCaught(this.mContext, new Throwable());
        ((ChannelHandlerContext)Mockito.verify((Object)this.mContext, (VerificationMode)Mockito.times((int)1))).close();
    }
}

