/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.client.lineage.LineageContext;
import alluxio.client.lineage.LineageMasterClient;
import alluxio.exception.ExceptionMessage;
import alluxio.thrift.LineageMasterClientService;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LineageMasterClient.class})
public class LineageMasterClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unsupportedVersionTest() throws Exception {
        LineageMasterClientService.Client mock = (LineageMasterClientService.Client)PowerMockito.mock(LineageMasterClientService.Client.class);
        PowerMockito.when((Object)mock.getServiceVersion()).thenReturn((Object)0L);
        LineageMasterClient client = LineageContext.INSTANCE.acquireMasterClient();
        try {
            Whitebox.invokeMethod((Object)client, (String)"checkVersion", (Object[])new Object[]{mock, 1L});
            Assert.fail((String)"checkVersion() should fail");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)ExceptionMessage.INCOMPATIBLE_VERSION.getMessage(new Object[]{"LineageMasterClient", 1L, 0}), (Object)e.getMessage());
        }
        finally {
            LineageContext.INSTANCE.releaseMasterClient(client);
        }
    }
}

