/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.AlluxioURI;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.lineage.DummyFileOutputStream;
import alluxio.client.lineage.LineageContext;
import alluxio.client.lineage.LineageFileOutStream;
import alluxio.client.lineage.LineageFileSystem;
import alluxio.client.lineage.LineageMasterClient;
import alluxio.exception.LineageDoesNotExistException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LineageContext.class, LineageMasterClient.class, FileSystemContext.class, FileSystemMasterClient.class})
public final class LineageFileSystemTest {
    private static final long TEST_BLOCK_SIZE = 0x100000L;
    private LineageContext mLineageContext;
    private LineageMasterClient mLineageMasterClient;
    private LineageFileSystem mAlluxioLineageFileSystem;
    private FileSystemContext mFileSystemContext;
    private FileSystemMasterClient mFileSystemMasterClient;

    @Before
    public void before() {
        this.mLineageMasterClient = (LineageMasterClient)PowerMockito.mock(LineageMasterClient.class);
        this.mLineageContext = (LineageContext)PowerMockito.mock(LineageContext.class);
        Mockito.when((Object)this.mLineageContext.acquireMasterClient()).thenReturn((Object)this.mLineageMasterClient);
        Whitebox.setInternalState(LineageContext.class, (String)"INSTANCE", (Object)this.mLineageContext);
        this.mAlluxioLineageFileSystem = LineageFileSystem.get();
        Whitebox.setInternalState((Object)this.mAlluxioLineageFileSystem, (String)"mLineageContext", (Object)this.mLineageContext);
        this.mFileSystemContext = (FileSystemContext)PowerMockito.mock(FileSystemContext.class);
        this.mFileSystemMasterClient = (FileSystemMasterClient)PowerMockito.mock(FileSystemMasterClient.class);
        Mockito.when((Object)this.mFileSystemContext.acquireMasterClient()).thenReturn((Object)this.mFileSystemMasterClient);
        Whitebox.setInternalState(FileSystemContext.class, (String)"INSTANCE", (Object)this.mFileSystemContext);
        Whitebox.setInternalState((Object)this.mAlluxioLineageFileSystem, (String)"mContext", (Object)this.mFileSystemContext);
    }

    @Test
    public void getLineageOutStreamTest() throws Exception {
        AlluxioURI path = new AlluxioURI("test");
        Mockito.when((Object)this.mLineageMasterClient.reinitializeFile("test", 0x100000L, 0L)).thenReturn((Object)1L);
        CreateFileOptions options = CreateFileOptions.defaults().setBlockSizeBytes(0x100000L).setTtl(0L);
        FileOutStream outStream = this.mAlluxioLineageFileSystem.createFile(path, options);
        Assert.assertTrue((boolean)(outStream instanceof LineageFileOutStream));
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }

    @Test
    public void getDummyOutStreamTest() throws Exception {
        AlluxioURI path = new AlluxioURI("test");
        Mockito.when((Object)this.mLineageMasterClient.reinitializeFile("test", 0x100000L, 0L)).thenReturn((Object)-1L);
        CreateFileOptions options = CreateFileOptions.defaults().setBlockSizeBytes(0x100000L).setTtl(0L);
        FileOutStream outStream = this.mAlluxioLineageFileSystem.createFile(path, options);
        Assert.assertTrue((boolean)(outStream instanceof DummyFileOutputStream));
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }

    @Test
    public void getNonLineageStreamTest() throws Exception {
        AlluxioURI path = new AlluxioURI("test");
        Mockito.when((Object)this.mLineageMasterClient.reinitializeFile("test", 0x100000L, 0L)).thenThrow(new Throwable[]{new LineageDoesNotExistException("lineage does not exist")});
        CreateFileOptions options = CreateFileOptions.defaults().setBlockSizeBytes(0x100000L).setTtl(0L);
        FileOutStream outStream = this.mAlluxioLineageFileSystem.createFile(path, options);
        Assert.assertTrue((boolean)(outStream instanceof FileOutStream));
        Assert.assertFalse((boolean)(outStream instanceof LineageFileOutStream));
        Assert.assertFalse((boolean)(outStream instanceof DummyFileOutputStream));
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }

    @Test
    public void reportLostFileTest() throws Exception {
        AlluxioURI path = new AlluxioURI("test");
        this.mAlluxioLineageFileSystem.reportLostFile(path);
        ((LineageMasterClient)Mockito.verify((Object)this.mLineageMasterClient)).reportLostFile("test");
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }
}

