/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.AlluxioURI;
import alluxio.client.ClientContext;
import alluxio.client.lineage.AlluxioLineage;
import alluxio.client.lineage.LineageContext;
import alluxio.client.lineage.LineageMasterClient;
import alluxio.client.lineage.options.DeleteLineageOptions;
import alluxio.client.util.ClientTestUtils;
import alluxio.job.CommandLineJob;
import alluxio.job.Job;
import alluxio.job.JobConf;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LineageContext.class, LineageMasterClient.class, ClientContext.class})
public final class AlluxioLineageTest {
    private LineageContext mLineageContext;
    private LineageMasterClient mLineageMasterClient;
    private AlluxioLineage mAlluxioLineage;

    @Before
    public void before() throws Exception {
        ClientContext.getConf().set("alluxio.user.lineage.enabled", "true");
        this.mLineageMasterClient = (LineageMasterClient)PowerMockito.mock(LineageMasterClient.class);
        this.mLineageContext = (LineageContext)PowerMockito.mock(LineageContext.class);
        Mockito.when((Object)this.mLineageContext.acquireMasterClient()).thenReturn((Object)this.mLineageMasterClient);
        Whitebox.setInternalState(LineageContext.class, (String)"INSTANCE", (Object)this.mLineageContext);
        this.mAlluxioLineage = AlluxioLineage.get();
        Whitebox.setInternalState((Object)this.mAlluxioLineage, (String)"mContext", (Object)this.mLineageContext);
    }

    @After
    public void after() {
        ClientTestUtils.resetClientContext();
    }

    @Test
    public void getInstanceTest() {
        AlluxioLineage tl = AlluxioLineage.get();
        Assert.assertEquals((Object)tl, (Object)AlluxioLineage.get());
    }

    @Test
    public void createLineageTest() throws Exception {
        ArrayList inputFiles = Lists.newArrayList((Object[])new AlluxioURI[]{new AlluxioURI("input")});
        ArrayList outputFiles = Lists.newArrayList((Object[])new AlluxioURI[]{new AlluxioURI("output")});
        CommandLineJob job = new CommandLineJob("cmd", new JobConf("out"));
        this.mAlluxioLineage.createLineage((List)inputFiles, (List)outputFiles, (Job)job);
        ((LineageMasterClient)Mockito.verify((Object)this.mLineageMasterClient)).createLineage((List)Lists.newArrayList((Object[])new String[]{"input"}), (List)Lists.newArrayList((Object[])new String[]{"output"}), job);
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }

    @Test
    public void deleteLineageTest() throws Exception {
        DeleteLineageOptions options = DeleteLineageOptions.defaults().setCascade(true);
        this.mAlluxioLineage.deleteLineage(0L, options);
        ((LineageMasterClient)Mockito.verify((Object)this.mLineageMasterClient)).deleteLineage(0L, true);
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }

    @Test
    public void getLineageInfoList() throws Exception {
        this.mAlluxioLineage.getLineageInfoList();
        ((LineageMasterClient)Mockito.verify((Object)this.mLineageMasterClient)).getLineageInfoList();
        ((LineageContext)Mockito.verify((Object)this.mLineageContext)).releaseMasterClient(this.mLineageMasterClient);
    }
}

