/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.policy.SpecificHostPolicy;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class SpecificHostPolicyTest {
    private static final int PORT = 1;

    @Test
    public void policyTest() {
        SpecificHostPolicy policy = new SpecificHostPolicy("worker2");
        ArrayList workerInfoList = Lists.newArrayList();
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost("worker1").setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost("worker2").setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        Assert.assertEquals((Object)"worker2", (Object)policy.getWorkerForNextBlock((List)workerInfoList, 0x100000L).getHost());
    }

    @Test
    public void noMatchingHostTest() {
        SpecificHostPolicy policy = new SpecificHostPolicy("worker3");
        ArrayList workerInfoList = Lists.newArrayList();
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost("worker1").setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost("worker2").setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        Assert.assertNull((Object)policy.getWorkerForNextBlock((List)workerInfoList, 0x100000L));
    }
}

