/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.policy;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.policy.LocalFirstPolicy;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class LocalFirstPolicyTest {
    private static final int PORT = 1;

    @Test
    public void getLocalFirst() {
        String localhostName = NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf());
        LocalFirstPolicy policy = new LocalFirstPolicy();
        ArrayList workerInfoList = Lists.newArrayList();
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost("worker1").setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost(localhostName).setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        Assert.assertEquals((Object)localhostName, (Object)policy.getWorkerForNextBlock((List)workerInfoList, 0x100000L).getHost());
    }

    @Test
    public void getOthersWhenNotEnoughSpaceOnLocal() {
        String localhostName = NetworkAddressUtils.getLocalHostName((Configuration)ClientContext.getConf());
        LocalFirstPolicy policy = new LocalFirstPolicy();
        ArrayList workerInfoList = Lists.newArrayList();
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost("worker1").setRpcPort(1).setDataPort(1).setWebPort(1), 0x40000000L, 0L));
        workerInfoList.add(new BlockWorkerInfo(new WorkerNetAddress().setHost(localhostName).setRpcPort(1).setDataPort(1).setWebPort(1), 0x100000L, 0x100000L));
        Assert.assertEquals((Object)"worker1", (Object)policy.getWorkerForNextBlock((List)workerInfoList, 0x40000000L).getHost());
    }
}

