/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.file.options.SetAttributeOptions;
import alluxio.thrift.SetAttributeTOptions;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class SetAttributeOptionsTest {
    @Test
    public void defaultsTest() {
        SetAttributeOptions options = SetAttributeOptions.defaults();
        Assert.assertFalse((boolean)options.hasPersisted());
        Assert.assertFalse((boolean)options.hasPinned());
        Assert.assertFalse((boolean)options.hasTtl());
        Assert.assertFalse((boolean)options.hasOwner());
        Assert.assertFalse((boolean)options.hasGroup());
        Assert.assertFalse((boolean)options.hasPermission());
        Assert.assertFalse((boolean)options.isRecursive());
    }

    @Test
    public void fieldsTest() {
        Random random = new Random();
        boolean persisted = random.nextBoolean();
        boolean pinned = random.nextBoolean();
        long ttl = random.nextLong();
        byte[] bytes = new byte[5];
        random.nextBytes(bytes);
        String owner = new String(bytes);
        random.nextBytes(bytes);
        String group = new String(bytes);
        short permission = (short)random.nextInt();
        boolean recursive = random.nextBoolean();
        SetAttributeOptions options = SetAttributeOptions.defaults();
        options.setPersisted(persisted);
        options.setPinned(pinned);
        options.setTtl(ttl);
        options.setOwner(owner);
        options.setGroup(group);
        options.setPermission(permission);
        options.setRecursive(recursive);
        Assert.assertTrue((boolean)options.hasPersisted());
        Assert.assertEquals((Object)persisted, (Object)options.getPersisted());
        Assert.assertTrue((boolean)options.hasPinned());
        Assert.assertEquals((Object)pinned, (Object)options.getPinned());
        Assert.assertTrue((boolean)options.hasTtl());
        Assert.assertEquals((long)ttl, (long)options.getTtl());
        Assert.assertTrue((boolean)options.hasOwner());
        Assert.assertEquals((Object)owner, (Object)options.getOwner());
        Assert.assertTrue((boolean)options.hasGroup());
        Assert.assertEquals((Object)group, (Object)options.getGroup());
        Assert.assertTrue((boolean)options.hasPermission());
        Assert.assertEquals((long)permission, (long)options.getPermission());
        Assert.assertEquals((Object)recursive, (Object)options.isRecursive());
    }

    @Test
    public void toThriftTest() {
        Random random = new Random();
        boolean persisted = random.nextBoolean();
        boolean pinned = random.nextBoolean();
        long ttl = random.nextLong();
        SetAttributeOptions options = SetAttributeOptions.defaults();
        options.setPersisted(persisted);
        options.setPinned(pinned);
        options.setTtl(ttl);
        SetAttributeTOptions thriftOptions = options.toThrift();
        Assert.assertTrue((boolean)thriftOptions.isSetPersisted());
        Assert.assertEquals((Object)persisted, (Object)thriftOptions.isPersisted());
        Assert.assertTrue((boolean)thriftOptions.isSetPinned());
        Assert.assertEquals((Object)pinned, (Object)thriftOptions.isPinned());
        Assert.assertTrue((boolean)thriftOptions.isSetTtl());
        Assert.assertEquals((long)ttl, (long)thriftOptions.getTtl());
    }
}

