/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.AlluxioStorageType;
import alluxio.client.ClientContext;
import alluxio.client.UnderStorageType;
import alluxio.client.WriteType;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.client.file.policy.LocalFirstPolicy;
import alluxio.client.file.policy.RoundRobinPolicy;
import alluxio.client.util.ClientTestUtils;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class OutStreamOptionsTest {
    @Test
    public void defaultsTest() {
        AlluxioStorageType alluxioType = AlluxioStorageType.STORE;
        UnderStorageType ufsType = UnderStorageType.SYNC_PERSIST;
        ClientContext.getConf().set("alluxio.user.block.size.bytes.default", "64MB");
        ClientContext.getConf().set("alluxio.user.file.writetype.default", WriteType.CACHE_THROUGH.toString());
        OutStreamOptions options = OutStreamOptions.defaults();
        Assert.assertEquals((long)0x4000000L, (long)options.getBlockSizeBytes());
        Assert.assertEquals((Object)alluxioType, (Object)options.getAlluxioStorageType());
        Assert.assertEquals((long)-1L, (long)options.getTtl());
        Assert.assertEquals((Object)ufsType, (Object)options.getUnderStorageType());
        Assert.assertTrue((boolean)(options.getLocationPolicy() instanceof LocalFirstPolicy));
        ClientTestUtils.resetClientContext();
    }

    @Test
    public void fieldsTest() {
        Random random = new Random();
        long blockSize = random.nextLong();
        RoundRobinPolicy policy = new RoundRobinPolicy();
        long ttl = random.nextLong();
        WriteType writeType = WriteType.NONE;
        OutStreamOptions options = OutStreamOptions.defaults();
        options.setBlockSizeBytes(blockSize);
        options.setLocationPolicy((FileWriteLocationPolicy)policy);
        options.setTtl(ttl);
        options.setWriteType(writeType);
        Assert.assertEquals((long)blockSize, (long)options.getBlockSizeBytes());
        Assert.assertEquals((Object)policy, (Object)options.getLocationPolicy());
        Assert.assertEquals((long)ttl, (long)options.getTtl());
        Assert.assertEquals((Object)writeType.getAlluxioStorageType(), (Object)options.getAlluxioStorageType());
        Assert.assertEquals((Object)writeType.getUnderStorageType(), (Object)options.getUnderStorageType());
    }
}

