/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.file.options.InStreamOptions;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.client.file.policy.RoundRobinPolicy;
import org.junit.Assert;
import org.junit.Test;

public class OpenFileOptionsTest {
    private final ReadType mDefaultReadType = (ReadType)ClientContext.getConf().getEnum("alluxio.user.file.readtype.default", ReadType.class);

    @Test
    public void defaultsTest() {
        OpenFileOptions options = OpenFileOptions.defaults();
        Assert.assertEquals((Object)this.mDefaultReadType.getAlluxioStorageType(), (Object)options.getAlluxioStorageType());
    }

    @Test
    public void fieldsTest() {
        RoundRobinPolicy policy = new RoundRobinPolicy();
        ReadType readType = ReadType.NO_CACHE;
        OpenFileOptions options = OpenFileOptions.defaults();
        options.setReadType(readType);
        options.setLocationPolicy((FileWriteLocationPolicy)policy);
        Assert.assertEquals((Object)readType.getAlluxioStorageType(), (Object)options.getAlluxioStorageType());
        Assert.assertEquals((Object)policy, (Object)options.getLocationPolicy());
    }

    @Test
    public void toInStreamOptionsTest() {
        OpenFileOptions options = OpenFileOptions.defaults();
        InStreamOptions inStreamOptions = options.toInStreamOptions();
        Assert.assertEquals((Object)options.getAlluxioStorageType(), (Object)inStreamOptions.getAlluxioStorageType());
        Assert.assertEquals((Object)options.getLocationPolicy(), (Object)inStreamOptions.getLocationPolicy());
    }
}

