/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.AlluxioStorageType;
import alluxio.client.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.file.options.InStreamOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.client.file.policy.RoundRobinPolicy;
import alluxio.client.util.ClientTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class InStreamOptionsTest {
    @Test
    public void defaultsTest() {
        InStreamOptions options = InStreamOptions.defaults();
        Assert.assertEquals((Object)AlluxioStorageType.PROMOTE, (Object)options.getAlluxioStorageType());
    }

    @Test
    public void fieldsTest() {
        ReadType readType = ReadType.NO_CACHE;
        RoundRobinPolicy policy = new RoundRobinPolicy();
        InStreamOptions options = InStreamOptions.defaults();
        options.setReadType(readType);
        options.setLocationPolicy((FileWriteLocationPolicy)policy);
        Assert.assertEquals((Object)options.getAlluxioStorageType(), (Object)readType.getAlluxioStorageType());
        Assert.assertEquals((Object)policy, (Object)options.getLocationPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void modifiedConfTest() {
        ClientContext.getConf().set("alluxio.user.file.readtype.default", ReadType.NO_CACHE.toString());
        try {
            InStreamOptions options = InStreamOptions.defaults();
            Assert.assertEquals((Object)ReadType.NO_CACHE.getAlluxioStorageType(), (Object)options.getAlluxioStorageType());
        }
        finally {
            ClientTestUtils.resetClientContext();
        }
    }
}

