/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ClientContext;
import alluxio.client.WriteType;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.client.file.policy.RoundRobinPolicy;
import alluxio.thrift.CreateFileTOptions;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class CreateFileOptionsTest {
    private final long mDefaultBlockSizeBytes = ClientContext.getConf().getBytes("alluxio.user.block.size.bytes.default");
    private final WriteType mDefaultWriteType = (WriteType)ClientContext.getConf().getEnum("alluxio.user.file.writetype.default", WriteType.class);

    @Test
    public void defaultsTest() {
        CreateFileOptions options = CreateFileOptions.defaults();
        Assert.assertTrue((boolean)options.isRecursive());
        Assert.assertEquals((long)this.mDefaultBlockSizeBytes, (long)options.getBlockSizeBytes());
        Assert.assertEquals((Object)this.mDefaultWriteType.getAlluxioStorageType(), (Object)options.getAlluxioStorageType());
        Assert.assertEquals((Object)this.mDefaultWriteType.getUnderStorageType(), (Object)options.getUnderStorageType());
        Assert.assertEquals((long)-1L, (long)options.getTtl());
    }

    @Test
    public void fieldsTest() {
        Random random = new Random();
        long blockSize = random.nextLong();
        RoundRobinPolicy policy = new RoundRobinPolicy();
        boolean recursive = random.nextBoolean();
        long ttl = random.nextLong();
        WriteType writeType = WriteType.NONE;
        CreateFileOptions options = CreateFileOptions.defaults();
        options.setBlockSizeBytes(blockSize);
        options.setLocationPolicy((FileWriteLocationPolicy)policy);
        options.setRecursive(recursive);
        options.setTtl(ttl);
        options.setWriteType(writeType);
        Assert.assertEquals((long)blockSize, (long)options.getBlockSizeBytes());
        Assert.assertEquals((Object)policy, (Object)options.getLocationPolicy());
        Assert.assertEquals((Object)recursive, (Object)options.isRecursive());
        Assert.assertEquals((long)ttl, (long)options.getTtl());
        Assert.assertEquals((Object)writeType.getAlluxioStorageType(), (Object)options.getAlluxioStorageType());
        Assert.assertEquals((Object)writeType.getUnderStorageType(), (Object)options.getUnderStorageType());
    }

    @Test
    public void toThriftTest() {
        CreateFileOptions options = CreateFileOptions.defaults();
        CreateFileTOptions thriftOptions = options.toThrift();
        Assert.assertTrue((boolean)thriftOptions.isRecursive());
        Assert.assertTrue((boolean)thriftOptions.isSetPersisted());
        Assert.assertEquals((Object)this.mDefaultWriteType.getUnderStorageType().isSyncPersist(), (Object)thriftOptions.isPersisted());
        Assert.assertEquals((long)this.mDefaultBlockSizeBytes, (long)thriftOptions.getBlockSizeBytes());
        Assert.assertEquals((long)-1L, (long)thriftOptions.getTtl());
    }
}

