/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ClientContext;
import alluxio.client.WriteType;
import alluxio.client.file.options.CreateDirectoryOptions;
import alluxio.thrift.CreateDirectoryTOptions;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class CreateDirectoryOptionsTest {
    private final WriteType mDefaultWriteType = (WriteType)ClientContext.getConf().getEnum("alluxio.user.file.writetype.default", WriteType.class);

    @Test
    public void defaultsTest() {
        CreateDirectoryOptions options = CreateDirectoryOptions.defaults();
        Assert.assertFalse((boolean)options.isAllowExists());
        Assert.assertFalse((boolean)options.isRecursive());
        Assert.assertEquals((Object)this.mDefaultWriteType.getUnderStorageType(), (Object)options.getUnderStorageType());
    }

    @Test
    public void fieldsTest() {
        Random random = new Random();
        boolean allowExists = random.nextBoolean();
        boolean recursive = random.nextBoolean();
        WriteType writeType = WriteType.NONE;
        CreateDirectoryOptions options = CreateDirectoryOptions.defaults();
        options.setAllowExists(allowExists);
        options.setRecursive(recursive);
        options.setWriteType(writeType);
        Assert.assertEquals((Object)allowExists, (Object)options.isAllowExists());
        Assert.assertEquals((Object)recursive, (Object)options.isRecursive());
        Assert.assertEquals((Object)writeType.getUnderStorageType(), (Object)options.getUnderStorageType());
    }

    @Test
    public void toThriftTest() {
        Random random = new Random();
        boolean allowExists = random.nextBoolean();
        boolean recursive = random.nextBoolean();
        WriteType writeType = WriteType.NONE;
        CreateDirectoryOptions options = CreateDirectoryOptions.defaults();
        options.setAllowExists(allowExists);
        options.setRecursive(recursive);
        options.setWriteType(writeType);
        CreateDirectoryTOptions thriftOptions = options.toThrift();
        Assert.assertEquals((Object)allowExists, (Object)thriftOptions.isAllowExists());
        Assert.assertEquals((Object)recursive, (Object)thriftOptions.isRecursive());
        Assert.assertEquals((Object)writeType.getUnderStorageType().isSyncPersist(), (Object)thriftOptions.isPersisted());
    }
}

