/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.exception.ExceptionMessage;
import alluxio.thrift.FileSystemMasterClientService;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FileSystemMasterClient.class})
public class FileSystemMasterClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unsupportedVersionTest() throws Exception {
        FileSystemMasterClientService.Client mock = (FileSystemMasterClientService.Client)PowerMockito.mock(FileSystemMasterClientService.Client.class);
        PowerMockito.when((Object)mock.getServiceVersion()).thenReturn((Object)0L);
        FileSystemMasterClient client = FileSystemContext.INSTANCE.acquireMasterClient();
        try {
            Whitebox.invokeMethod((Object)client, (String)"checkVersion", (Object[])new Object[]{mock, 1L});
            Assert.fail((String)"checkVersion() should fail");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)ExceptionMessage.INCOMPATIBLE_VERSION.getMessage(new Object[]{"FileSystemMasterClient", 1L, 0}), (Object)e.getMessage());
        }
        finally {
            FileSystemContext.INSTANCE.releaseMasterClient(client);
        }
    }
}

