/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.ClientContext;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public final class FileSystemContextTest {
    @Test(timeout=10000L)
    public void acquireAtMaxLimitTest() throws Exception {
        ArrayList clients = Lists.newArrayList();
        for (int i = 0; i < ClientContext.getConf().getInt("alluxio.user.file.master.client.threads"); ++i) {
            clients.add(FileSystemContext.INSTANCE.acquireMasterClient());
        }
        Thread acquireThread = new Thread(new AcquireClient());
        acquireThread.start();
        long timeoutMs = 500L;
        long start = System.currentTimeMillis();
        acquireThread.join(timeoutMs);
        if (System.currentTimeMillis() - start < timeoutMs) {
            Assert.fail((String)"Acquired a master client when the client pool was full.");
        }
        for (FileSystemMasterClient client : clients) {
            FileSystemContext.INSTANCE.releaseMasterClient(client);
        }
        timeoutMs = 5000L;
        start = System.currentTimeMillis();
        acquireThread.join(timeoutMs);
        if (System.currentTimeMillis() - start >= timeoutMs) {
            Assert.fail((String)("Failed to acquire a master client within " + timeoutMs + "ms. Deadlock?"));
        }
    }

    class AcquireClient
    implements Runnable {
        AcquireClient() {
        }

        @Override
        public void run() {
            FileSystemMasterClient client = FileSystemContext.INSTANCE.acquireMasterClient();
            FileSystemContext.INSTANCE.releaseMasterClient(client);
        }
    }
}

