/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.BufferedBlockOutStream;
import alluxio.client.block.TestBufferedBlockOutStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CompleteFileOptions;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.client.file.policy.LocalFirstPolicy;
import alluxio.client.file.policy.RoundRobinPolicy;
import alluxio.client.util.ClientMockUtils;
import alluxio.client.util.ClientTestUtils;
import alluxio.exception.ExceptionMessage;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.BufferUtils;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FileSystemContext.class, BlockStoreContext.class, FileSystemMasterClient.class, AlluxioBlockStore.class, UnderFileSystem.class, BlockWorkerClient.class})
public class FileOutStreamTest {
    private static final long BLOCK_LENGTH = 100L;
    private static final AlluxioURI FILE_NAME = new AlluxioURI("/file");
    private AlluxioBlockStore mBlockStore;
    private BlockStoreContext mBlockStoreContext;
    private FileSystemContext mFileSystemContext;
    private FileSystemMasterClient mFileSystemMasterClient;
    private UnderFileSystem mUnderFileSystem;
    private BlockWorkerClient mBlockWorkerClient;
    private Map<Long, TestBufferedBlockOutStream> mAlluxioOutStreamMap;
    private ByteArrayOutputStream mUnderStorageOutputStream;
    private AtomicBoolean mUnderStorageFlushed;
    private FileOutStream mTestStream;

    @Before
    public void before() throws Exception {
        ClientTestUtils.setSmallBufferSizes();
        this.mFileSystemContext = (FileSystemContext)PowerMockito.mock(FileSystemContext.class);
        this.mBlockStore = (AlluxioBlockStore)PowerMockito.mock(AlluxioBlockStore.class);
        this.mBlockStoreContext = (BlockStoreContext)PowerMockito.mock(BlockStoreContext.class);
        this.mFileSystemMasterClient = (FileSystemMasterClient)PowerMockito.mock(FileSystemMasterClient.class);
        this.mBlockWorkerClient = (BlockWorkerClient)PowerMockito.mock(BlockWorkerClient.class);
        Mockito.when((Object)this.mFileSystemContext.getAluxioBlockStore()).thenReturn((Object)this.mBlockStore);
        Mockito.when((Object)this.mBlockStoreContext.acquireWorkerClient()).thenReturn((Object)this.mBlockWorkerClient);
        Mockito.when((Object)this.mFileSystemContext.acquireMasterClient()).thenReturn((Object)this.mFileSystemMasterClient);
        Mockito.when((Object)this.mFileSystemMasterClient.getStatus((AlluxioURI)Mockito.any(AlluxioURI.class))).thenReturn((Object)new URIStatus(new FileInfo()));
        Mockito.when((Object)this.mFileSystemMasterClient.getNewBlockIdForFile(FILE_NAME)).thenAnswer((Answer)new Answer<Long>(){
            private long mCount = 0L;

            public Long answer(InvocationOnMock invocation) throws Throwable {
                return this.mCount++;
            }
        });
        final HashMap outStreamMap = Maps.newHashMap();
        Mockito.when((Object)this.mBlockStore.getOutStream(Mockito.anyLong(), Mockito.eq((long)100L), (WorkerNetAddress)Mockito.any(WorkerNetAddress.class))).thenAnswer((Answer)new Answer<BufferedBlockOutStream>(){

            public BufferedBlockOutStream answer(InvocationOnMock invocation) throws Throwable {
                Long blockId = (Long)invocation.getArgumentAt(0, Long.class);
                if (!outStreamMap.containsKey(blockId)) {
                    TestBufferedBlockOutStream newStream = new TestBufferedBlockOutStream(blockId, 100L);
                    outStreamMap.put(blockId, newStream);
                }
                return (BufferedBlockOutStream)outStreamMap.get(blockId);
            }
        });
        BlockWorkerInfo workerInfo = new BlockWorkerInfo(new WorkerNetAddress().setHost("localhost").setRpcPort(1).setDataPort(2).setWebPort(3), 0x40000000L, 0L);
        Mockito.when((Object)this.mBlockStore.getWorkerInfoList()).thenReturn((Object)Lists.newArrayList((Object[])new BlockWorkerInfo[]{workerInfo}));
        this.mAlluxioOutStreamMap = outStreamMap;
        final AtomicBoolean underStorageFlushed = new AtomicBoolean(false);
        this.mUnderStorageOutputStream = new ByteArrayOutputStream(){

            @Override
            public void flush() {
                underStorageFlushed.set(true);
            }
        };
        this.mUnderStorageFlushed = underStorageFlushed;
        this.mUnderFileSystem = ClientMockUtils.mockUnderFileSystem();
        Mockito.when((Object)this.mUnderFileSystem.create(Mockito.anyString(), Mockito.eq((int)100))).thenReturn((Object)this.mUnderStorageOutputStream);
        OutStreamOptions options = OutStreamOptions.defaults().setBlockSizeBytes(100L).setWriteType(WriteType.CACHE_THROUGH);
        this.mTestStream = this.createTestStream(FILE_NAME, options);
    }

    @After
    public void after() {
        ClientTestUtils.resetClientContext();
    }

    @Test
    public void singleByteWriteTest() throws Exception {
        this.mTestStream.write(5);
        Assert.assertArrayEquals((byte[])new byte[]{5}, (byte[])this.mAlluxioOutStreamMap.get(0L).getWrittenData());
    }

    @Test
    public void manyBytesWriteTest() throws IOException {
        int bytesToWrite = 550;
        for (int i = 0; i < bytesToWrite; ++i) {
            this.mTestStream.write(i);
        }
        this.verifyIncreasingBytesWritten(bytesToWrite);
    }

    @Test
    public void writeBufferTest() throws IOException {
        int bytesToWrite = 550;
        this.mTestStream.write(BufferUtils.getIncreasingByteArray((int)bytesToWrite));
        this.verifyIncreasingBytesWritten(bytesToWrite);
    }

    @Test
    public void writeOffsetTest() throws IOException {
        int bytesToWrite = 550;
        int offset = 33;
        this.mTestStream.write(BufferUtils.getIncreasingByteArray((int)(bytesToWrite + offset)), offset, bytesToWrite);
        this.verifyIncreasingBytesWritten(offset, bytesToWrite);
    }

    @Test
    public void closeTest() throws Exception {
        Mockito.when((Object)this.mUnderFileSystem.rename(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)true);
        this.mTestStream.write(BufferUtils.getIncreasingByteArray((int)150));
        this.mTestStream.close();
        for (long streamIndex = 0L; streamIndex < 2L; ++streamIndex) {
            Assert.assertFalse((boolean)this.mAlluxioOutStreamMap.get(streamIndex).isCanceled());
            Assert.assertTrue((boolean)this.mAlluxioOutStreamMap.get(streamIndex).isClosed());
        }
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).completeFile((AlluxioURI)Mockito.eq((Object)FILE_NAME), (CompleteFileOptions)Mockito.any(CompleteFileOptions.class));
    }

    @Test
    public void cancelTest() throws Exception {
        this.mTestStream.write(BufferUtils.getIncreasingByteArray((int)150));
        this.mTestStream.cancel();
        for (long streamIndex = 0L; streamIndex < 2L; ++streamIndex) {
            Assert.assertTrue((boolean)this.mAlluxioOutStreamMap.get(streamIndex).isClosed());
            Assert.assertTrue((boolean)this.mAlluxioOutStreamMap.get(streamIndex).isCanceled());
        }
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient, (VerificationMode)Mockito.times((int)0))).completeFile(FILE_NAME, CompleteFileOptions.defaults());
        ((UnderFileSystem)Mockito.verify((Object)this.mUnderFileSystem)).delete(Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void flushTest() throws IOException {
        Assert.assertFalse((boolean)this.mUnderStorageFlushed.get());
        this.mTestStream.flush();
        Assert.assertTrue((boolean)this.mUnderStorageFlushed.get());
    }

    @Test
    public void cacheWriteExceptionNonSyncPersistTest() throws IOException {
        OutStreamOptions options = OutStreamOptions.defaults().setBlockSizeBytes(100L).setWriteType(WriteType.MUST_CACHE);
        this.mTestStream = this.createTestStream(FILE_NAME, options);
        BufferedBlockOutStream stream = (BufferedBlockOutStream)Mockito.mock(BufferedBlockOutStream.class);
        Whitebox.setInternalState((Object)this.mTestStream, (String)"mCurrentBlockOutStream", (Object)stream);
        Mockito.when((Object)stream.remaining()).thenReturn((Object)100L);
        ((BufferedBlockOutStream)Mockito.doThrow((Throwable)new IOException("test error")).when((Object)stream)).write(7);
        try {
            this.mTestStream.write(7);
            Assert.fail((String)"the test should fail");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)ExceptionMessage.FAILED_CACHE.getMessage(new Object[]{"test error"}), (Object)e.getMessage());
        }
    }

    @Test
    public void cacheWriteExceptionSyncPersistTest() throws IOException {
        BufferedBlockOutStream stream = (BufferedBlockOutStream)Mockito.mock(BufferedBlockOutStream.class);
        Whitebox.setInternalState((Object)this.mTestStream, (String)"mCurrentBlockOutStream", (Object)stream);
        Mockito.when((Object)stream.remaining()).thenReturn((Object)100L);
        ((BufferedBlockOutStream)Mockito.doThrow((Throwable)new IOException("test error")).when((Object)stream)).write(7);
        this.mTestStream.write(7);
        Assert.assertArrayEquals((byte[])new byte[]{7}, (byte[])this.mUnderStorageOutputStream.toByteArray());
        Assert.assertFalse((boolean)((Boolean)Whitebox.getInternalState((Object)this.mTestStream, (String)"mShouldCacheCurrentBlock")));
    }

    @Test
    public void truncateWriteTest() throws IOException {
        this.mTestStream.write(0x1FFFFF00);
        this.mTestStream.write(0x1FFFFF01);
        this.verifyIncreasingBytesWritten(2);
    }

    @Test
    public void writeBadBufferOffsetTest() throws IOException {
        try {
            this.mTestStream.write(new byte[10], 5, 6);
            Assert.fail((String)"buffer write with invalid offset/length should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Buffer length: %s, offset: %s, len: %s", 10, 5, 6), (Object)e.getMessage());
        }
    }

    @Test
    public void writeNullBufferTest() throws IOException {
        try {
            this.mTestStream.write(null);
            Assert.fail((String)"writing null should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot write a null input buffer", (Object)e.getMessage());
        }
    }

    @Test
    public void writeNullBufferOffsetTest() throws IOException {
        try {
            this.mTestStream.write(null, 0, 0);
            Assert.fail((String)"writing null should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot write a null input buffer", (Object)e.getMessage());
        }
    }

    @Test
    public void asyncWriteTest() throws Exception {
        OutStreamOptions options = OutStreamOptions.defaults().setBlockSizeBytes(100L).setWriteType(WriteType.ASYNC_THROUGH);
        this.mTestStream = this.createTestStream(FILE_NAME, options);
        Mockito.when((Object)this.mUnderFileSystem.rename(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)true);
        this.mTestStream.write(BufferUtils.getIncreasingByteArray((int)150));
        this.mTestStream.close();
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).completeFile((AlluxioURI)Mockito.eq((Object)FILE_NAME), (CompleteFileOptions)Mockito.any(CompleteFileOptions.class));
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).scheduleAsyncPersist((AlluxioURI)Mockito.eq((Object)FILE_NAME));
    }

    @Test
    public void locationPolicyTest() throws IOException {
        OutStreamOptions options = OutStreamOptions.defaults().setBlockSizeBytes(100L).setWriteType(WriteType.MUST_CACHE);
        this.mTestStream = this.createTestStream(FILE_NAME, options);
        FileWriteLocationPolicy policy = (FileWriteLocationPolicy)Whitebox.getInternalState((Object)this.mTestStream, (String)"mLocationPolicy");
        Assert.assertTrue((boolean)(policy instanceof LocalFirstPolicy));
        options.setLocationPolicy((FileWriteLocationPolicy)new RoundRobinPolicy());
        this.mTestStream = this.createTestStream(FILE_NAME, options);
        policy = (FileWriteLocationPolicy)Whitebox.getInternalState((Object)this.mTestStream, (String)"mLocationPolicy");
        Assert.assertTrue((boolean)(policy instanceof RoundRobinPolicy));
    }

    @Test
    public void missingLocationPolicyTest() throws IOException {
        OutStreamOptions options = OutStreamOptions.defaults().setBlockSizeBytes(100L).setWriteType(WriteType.MUST_CACHE).setLocationPolicy(null);
        try {
            this.mTestStream = this.createTestStream(FILE_NAME, options);
            Assert.fail((String)"missing location policy should fail");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"The location policy is not specified", (Object)e.getMessage());
        }
    }

    @Test
    public void getBytesWrittenWithDifferentUnderStorageTypeTest() throws IOException {
        for (WriteType type : WriteType.values()) {
            OutStreamOptions options = OutStreamOptions.defaults().setBlockSizeBytes(100L).setWriteType(type);
            this.mTestStream = this.createTestStream(FILE_NAME, options);
            this.mTestStream.write(BufferUtils.getIncreasingByteArray((int)100));
            this.mTestStream.flush();
            Assert.assertEquals((long)100L, (long)this.mTestStream.getBytesWritten());
        }
    }

    private void verifyIncreasingBytesWritten(int len) {
        this.verifyIncreasingBytesWritten(0, len);
    }

    private void verifyIncreasingBytesWritten(int start, int len) {
        long filledStreams = (long)len / 100L;
        for (long streamIndex = 0L; streamIndex < filledStreams; ++streamIndex) {
            Assert.assertTrue((String)("stream " + streamIndex + " was never written"), (boolean)this.mAlluxioOutStreamMap.containsKey(streamIndex));
            Assert.assertArrayEquals((byte[])BufferUtils.getIncreasingByteArray((int)((int)(streamIndex * 100L + (long)start)), (int)100), (byte[])this.mAlluxioOutStreamMap.get(streamIndex).getWrittenData());
        }
        long lastStreamBytes = (long)len - filledStreams * 100L;
        Assert.assertArrayEquals((byte[])BufferUtils.getIncreasingByteArray((int)((int)(filledStreams * 100L + (long)start)), (int)((int)lastStreamBytes)), (byte[])this.mAlluxioOutStreamMap.get(filledStreams).getWrittenData());
        Assert.assertArrayEquals((byte[])BufferUtils.getIncreasingByteArray((int)start, (int)len), (byte[])this.mUnderStorageOutputStream.toByteArray());
    }

    private FileOutStream createTestStream(AlluxioURI path, OutStreamOptions options) throws IOException {
        Whitebox.setInternalState(BlockStoreContext.class, (String)"INSTANCE", (Object)this.mBlockStoreContext);
        Whitebox.setInternalState(FileSystemContext.class, (String)"INSTANCE", (Object)this.mFileSystemContext);
        FileOutStream stream = new FileOutStream(path, options);
        return stream;
    }
}

