/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.ClientContext;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.CreateDirectoryOptions;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.options.DeleteOptions;
import alluxio.client.file.options.FreeOptions;
import alluxio.client.file.options.GetStatusOptions;
import alluxio.client.file.options.ListStatusOptions;
import alluxio.client.file.options.LoadMetadataOptions;
import alluxio.client.file.options.MountOptions;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.client.file.options.RenameOptions;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.client.file.options.UnmountOptions;
import alluxio.wire.FileInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FileSystemContext.class, FileSystemMasterClient.class, ClientContext.class})
public final class BaseFileSystemTest {
    private static final RuntimeException EXCEPTION = new RuntimeException("test exception");
    private static final String SHOULD_HAVE_PROPAGATED_MESSAGE = "Exception should have been propagated";
    private FileSystem mFileSystem;
    private FileSystemContext mFileContext;
    private FileSystemMasterClient mFileSystemMasterClient;

    @Before
    public void before() {
        this.mFileSystem = new DummyAlluxioFileSystem();
        this.mFileContext = (FileSystemContext)PowerMockito.mock(FileSystemContext.class);
        Whitebox.setInternalState((Object)this.mFileSystem, (String)"mContext", (Object)this.mFileContext);
        this.mFileSystemMasterClient = (FileSystemMasterClient)PowerMockito.mock(FileSystemMasterClient.class);
        Mockito.when((Object)this.mFileContext.acquireMasterClient()).thenReturn((Object)this.mFileSystemMasterClient);
    }

    @After
    public void after() {
        ((FileSystemContext)Mockito.verify((Object)this.mFileContext)).acquireMasterClient();
        ((FileSystemContext)Mockito.verify((Object)this.mFileContext)).releaseMasterClient(this.mFileSystemMasterClient);
    }

    @Test
    public void createFileTest() throws Exception {
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mFileSystemMasterClient)).createFile((AlluxioURI)Mockito.any(AlluxioURI.class), (CreateFileOptions)Mockito.any(CreateFileOptions.class));
        AlluxioURI file = new AlluxioURI("/file");
        CreateFileOptions options = CreateFileOptions.defaults();
        FileOutStream out = this.mFileSystem.createFile(file, options);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).createFile(file, options);
        Assert.assertEquals((Object)out.mUri, (Object)file);
    }

    @Test
    public void createExceptionTest() throws Exception {
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).createFile((AlluxioURI)Mockito.any(AlluxioURI.class), (CreateFileOptions)Mockito.any(CreateFileOptions.class));
        CreateFileOptions options = CreateFileOptions.defaults();
        try {
            this.mFileSystem.createFile(new AlluxioURI("/"), options);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void deleteTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        DeleteOptions deleteOptions = DeleteOptions.defaults().setRecursive(true);
        this.mFileSystem.delete(file, deleteOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).delete(file, deleteOptions);
    }

    @Test
    public void deleteExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        DeleteOptions deleteOptions = DeleteOptions.defaults().setRecursive(true);
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).delete(file, deleteOptions);
        try {
            this.mFileSystem.delete(file, deleteOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void freeTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        FreeOptions freeOptions = FreeOptions.defaults().setRecursive(true);
        this.mFileSystem.free(file, freeOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).free(file, freeOptions);
    }

    @Test
    public void freeExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        FreeOptions freeOptions = FreeOptions.defaults().setRecursive(true);
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).free(file, freeOptions);
        try {
            this.mFileSystem.free(file, freeOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void getStatusTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        URIStatus status = new URIStatus(new FileInfo());
        Mockito.when((Object)this.mFileSystemMasterClient.getStatus(file)).thenReturn((Object)status);
        GetStatusOptions getStatusOptions = GetStatusOptions.defaults();
        Assert.assertSame((Object)status, (Object)this.mFileSystem.getStatus(file, getStatusOptions));
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).getStatus(file);
    }

    @Test
    public void getStatusExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        Mockito.when((Object)this.mFileSystemMasterClient.getStatus(file)).thenThrow(new Throwable[]{EXCEPTION});
        GetStatusOptions getStatusOptions = GetStatusOptions.defaults();
        try {
            this.mFileSystem.getStatus(file, getStatusOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void listStatusTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        ArrayList infos = Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(new FileInfo())});
        Mockito.when((Object)this.mFileSystemMasterClient.listStatus(file)).thenReturn((Object)infos);
        ListStatusOptions listStatusOptions = ListStatusOptions.defaults();
        Assert.assertSame((Object)infos, (Object)this.mFileSystem.listStatus(file, listStatusOptions));
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).listStatus(file);
    }

    @Test
    public void listStatusExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        Mockito.when((Object)this.mFileSystemMasterClient.listStatus(file)).thenThrow(new Throwable[]{EXCEPTION});
        ListStatusOptions listStatusOptions = ListStatusOptions.defaults();
        try {
            this.mFileSystem.listStatus(file, listStatusOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void loadMetadataTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        LoadMetadataOptions loadMetadataOptions = LoadMetadataOptions.defaults().setRecursive(true);
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mFileSystemMasterClient)).loadMetadata(file, loadMetadataOptions);
        this.mFileSystem.loadMetadata(file, loadMetadataOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).loadMetadata(file, loadMetadataOptions);
    }

    @Test
    public void loadMetadataExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        LoadMetadataOptions loadMetadataOptions = LoadMetadataOptions.defaults().setRecursive(true);
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).loadMetadata(file, loadMetadataOptions);
        try {
            this.mFileSystem.loadMetadata(file, loadMetadataOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void createDirectoryTest() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        CreateDirectoryOptions createDirectoryOptions = CreateDirectoryOptions.defaults();
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mFileSystemMasterClient)).createDirectory(dir, createDirectoryOptions);
        this.mFileSystem.createDirectory(dir, createDirectoryOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).createDirectory(dir, createDirectoryOptions);
    }

    @Test
    public void createDirectoryExceptionTest() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        CreateDirectoryOptions createDirectoryOptions = CreateDirectoryOptions.defaults();
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).createDirectory(dir, createDirectoryOptions);
        try {
            this.mFileSystem.createDirectory(dir, createDirectoryOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void mountTest() throws Exception {
        AlluxioURI alluxioPath = new AlluxioURI("/t");
        AlluxioURI ufsPath = new AlluxioURI("/u");
        MountOptions mountOptions = MountOptions.defaults();
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mFileSystemMasterClient)).mount(alluxioPath, ufsPath);
        this.mFileSystem.mount(alluxioPath, ufsPath, mountOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).mount(alluxioPath, ufsPath);
    }

    @Test
    public void mountExceptionTest() throws Exception {
        AlluxioURI alluxioPath = new AlluxioURI("/t");
        AlluxioURI ufsPath = new AlluxioURI("/u");
        MountOptions mountOptions = MountOptions.defaults();
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).mount(alluxioPath, ufsPath);
        try {
            this.mFileSystem.mount(alluxioPath, ufsPath, mountOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void openFileTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        URIStatus status = new URIStatus(new FileInfo());
        Mockito.when((Object)this.mFileSystemMasterClient.getStatus(file)).thenReturn((Object)status);
        OpenFileOptions openOptions = OpenFileOptions.defaults();
        this.mFileSystem.openFile(file, openOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).getStatus(file);
    }

    @Test
    public void openExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        URIStatus status = new URIStatus(new FileInfo());
        Mockito.when((Object)this.mFileSystemMasterClient.getStatus(file)).thenThrow(new Throwable[]{EXCEPTION});
        OpenFileOptions openOptions = OpenFileOptions.defaults();
        try {
            this.mFileSystem.openFile(file, openOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void renameTest() throws Exception {
        AlluxioURI src = new AlluxioURI("/file");
        AlluxioURI dst = new AlluxioURI("/file2");
        RenameOptions renameOptions = RenameOptions.defaults();
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mFileSystemMasterClient)).rename(src, dst);
        this.mFileSystem.rename(src, dst, renameOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).rename(src, dst);
    }

    @Test
    public void renameExceptionTest() throws Exception {
        AlluxioURI src = new AlluxioURI("/file");
        AlluxioURI dst = new AlluxioURI("/file2");
        RenameOptions renameOptions = RenameOptions.defaults();
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).rename(src, dst);
        try {
            this.mFileSystem.rename(src, dst, renameOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void setAttributeTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        SetAttributeOptions setAttributeOptions = SetAttributeOptions.defaults();
        this.mFileSystem.setAttribute(file, setAttributeOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).setAttribute(file, setAttributeOptions);
    }

    @Test
    public void setStateExceptionTest() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        SetAttributeOptions setAttributeOptions = SetAttributeOptions.defaults();
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).setAttribute(file, setAttributeOptions);
        try {
            this.mFileSystem.setAttribute(file, setAttributeOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    @Test
    public void unmountTest() throws Exception {
        AlluxioURI path = new AlluxioURI("/");
        UnmountOptions unmountOptions = UnmountOptions.defaults();
        ((FileSystemMasterClient)Mockito.doNothing().when((Object)this.mFileSystemMasterClient)).unmount(path);
        this.mFileSystem.unmount(path, unmountOptions);
        ((FileSystemMasterClient)Mockito.verify((Object)this.mFileSystemMasterClient)).unmount(path);
    }

    @Test
    public void unmountExceptionTest() throws Exception {
        AlluxioURI path = new AlluxioURI("/");
        UnmountOptions unmountOptions = UnmountOptions.defaults();
        ((FileSystemMasterClient)Mockito.doThrow((Throwable)EXCEPTION).when((Object)this.mFileSystemMasterClient)).unmount(path);
        try {
            this.mFileSystem.unmount(path, unmountOptions);
            Assert.fail((String)SHOULD_HAVE_PROPAGATED_MESSAGE);
        }
        catch (Exception e) {
            Assert.assertSame((Object)EXCEPTION, (Object)e);
        }
    }

    private class DummyAlluxioFileSystem
    extends BaseFileSystem {
        private DummyAlluxioFileSystem() {
        }
    }
}

