/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.block.BufferedBlockOutStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TestBufferedBlockOutStream
extends BufferedBlockOutStream {
    private static final int MAX_DATA = 1000;
    private ByteBuffer mDataWritten = ByteBuffer.allocate(1000);
    private boolean mCanceled = false;
    public byte[] mLastBufferedWriteArray;
    public int mLastBufferedWriteOffset;
    public int mLastBufferedWriteLen;
    public boolean mHasFlushed;

    public TestBufferedBlockOutStream(long blockId, long blockSize) {
        super(blockId, blockSize);
    }

    public byte[] getWrittenData() {
        this.flush();
        return Arrays.copyOfRange(this.mDataWritten.array(), 0, (int)this.mWrittenBytes);
    }

    public void setWrittenBytes(long numBytes) {
        this.mWrittenBytes = numBytes;
    }

    public int getWrittenBytes() {
        return (int)this.mWrittenBytes;
    }

    public int getFlushedBytes() {
        return (int)this.mFlushedBytes;
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void cancel() throws IOException {
        this.mCanceled = true;
        this.close();
    }

    public void close() {
        this.mClosed = true;
    }

    public void flush() {
        int bytesToWrite = this.mBuffer.position();
        this.mDataWritten.put(this.mBuffer.array(), 0, bytesToWrite);
        this.mFlushedBytes += (long)bytesToWrite;
        this.mBuffer.clear();
        this.mHasFlushed = true;
    }

    protected void unBufferedWrite(byte[] b, int off, int len) throws IOException {
        this.mLastBufferedWriteArray = b;
        this.mLastBufferedWriteOffset = off;
        this.mLastBufferedWriteLen = len;
    }
}

