/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.block.TestBufferedBlockOutStream;
import alluxio.util.io.BufferUtils;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BufferedBlockOutStreamTest {
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    private static final long BLOCK_LENGTH = 100L;
    private static final byte[] INCREASING_BYTES = BufferUtils.getIncreasingByteArray((int)100);
    private TestBufferedBlockOutStream mTestStream;

    @Before
    public void before() {
        this.mTestStream = new TestBufferedBlockOutStream(1L, 100L);
    }

    @Test
    public void remainingTest() {
        this.mTestStream.setWrittenBytes(100L);
        Assert.assertEquals((long)0L, (long)this.mTestStream.remaining());
        this.mTestStream.setWrittenBytes(40L);
        Assert.assertEquals((long)60L, (long)this.mTestStream.remaining());
        this.mTestStream.setWrittenBytes(0L);
        Assert.assertEquals((long)100L, (long)this.mTestStream.remaining());
    }

    @Test
    public void singleByteWriteTest() throws Exception {
        int i = 0;
        while ((long)i < 100L) {
            this.mTestStream.write(INCREASING_BYTES[i]);
            Assert.assertEquals((long)(i + 1), (long)this.mTestStream.getWrittenBytes());
            ++i;
        }
        Assert.assertArrayEquals((byte[])INCREASING_BYTES, (byte[])Arrays.copyOfRange(this.mTestStream.getBuffer().array(), 0, 100));
    }

    @Test
    public void byteArrayWriteTest() throws Exception {
        this.mTestStream.write(INCREASING_BYTES);
        Assert.assertEquals((long)INCREASING_BYTES.length, (long)this.mTestStream.getWrittenBytes());
        Assert.assertArrayEquals((byte[])INCREASING_BYTES, (byte[])Arrays.copyOfRange(this.mTestStream.getBuffer().array(), 0, 100));
    }

    @Test
    public void byteArrayAtOffsetTest() throws Exception {
        this.mTestStream.write(INCREASING_BYTES, 25, 50);
        Assert.assertEquals((long)50L, (long)this.mTestStream.getWrittenBytes());
        Assert.assertArrayEquals((byte[])BufferUtils.getIncreasingByteArray((int)25, (int)50), (byte[])Arrays.copyOfRange(this.mTestStream.getBuffer().array(), 0, 50));
        Assert.assertFalse((boolean)this.mTestStream.mHasFlushed);
        int bytesToWrite = this.mTestStream.getBuffer().limit() / 2 + 1;
        this.mTestStream.write(INCREASING_BYTES, 30, bytesToWrite);
        Assert.assertTrue((boolean)this.mTestStream.mHasFlushed);
        Assert.assertSame((Object)INCREASING_BYTES, (Object)this.mTestStream.mLastBufferedWriteArray);
        Assert.assertEquals((long)30L, (long)this.mTestStream.mLastBufferedWriteOffset);
        Assert.assertEquals((long)bytesToWrite, (long)this.mTestStream.mLastBufferedWriteLen);
        Assert.assertEquals((long)(50 + this.mTestStream.mLastBufferedWriteLen), (long)this.mTestStream.getWrittenBytes());
    }

    @Test
    public void writeToClosed() throws Exception {
        this.mTestStream.close();
        this.mThrown.expect(IllegalStateException.class);
        this.mThrown.expectMessage("Cannot do operations on a closed BlockOutStream");
        this.mTestStream.write(0);
    }

    @Test
    public void writePastBlock() throws Exception {
        this.mTestStream.setWrittenBytes(100L);
        this.mThrown.expect(IllegalStateException.class);
        this.mThrown.expectMessage("Cannot write past end of block");
        this.mTestStream.write(0);
    }

    @Test
    public void doubleFlush() throws Exception {
        this.mTestStream.write(INCREASING_BYTES, 1, 10);
        Assert.assertEquals((long)0L, (long)this.mTestStream.getFlushedBytes());
        this.mTestStream.flush();
        Assert.assertEquals((long)10L, (long)this.mTestStream.getFlushedBytes());
        this.mTestStream.flush();
        Assert.assertEquals((long)10L, (long)this.mTestStream.getFlushedBytes());
    }
}

