/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.block.TestBufferedBlockInStream;
import alluxio.util.io.BufferUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferedBlockInStreamTest {
    private static final long BLOCK_LENGTH = 100L;
    private TestBufferedBlockInStream mTestStream;

    @Before
    public void before() {
        this.mTestStream = new TestBufferedBlockInStream(1L, 0, 100L);
    }

    @Test
    public void singleByteReadTest() throws Exception {
        int i = 0;
        while ((long)i < 100L) {
            Assert.assertEquals((long)i, (long)this.mTestStream.read());
            ++i;
        }
    }

    @Test
    public void skipTest() throws Exception {
        Assert.assertEquals((long)10L, (long)this.mTestStream.skip(10L));
        Assert.assertEquals((long)10L, (long)this.mTestStream.read());
        Assert.assertEquals((long)0L, (long)this.mTestStream.skip(0L));
        Assert.assertEquals((long)11L, (long)this.mTestStream.read());
    }

    @Test
    public void seekTest() throws Exception {
        this.mTestStream.seek(10L);
        Assert.assertEquals((long)10L, (long)this.mTestStream.read());
        this.mTestStream.seek(2L);
        Assert.assertEquals((long)2L, (long)this.mTestStream.read());
        this.mTestStream.seek(100L);
        Assert.assertEquals((long)-1L, (long)this.mTestStream.read());
    }

    @Test
    public void bulkReadTest() throws Exception {
        int size = 10;
        byte[] readBytes = new byte[size];
        Assert.assertEquals((long)size, (long)this.mTestStream.read(readBytes));
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)0, (int)size, (byte[])readBytes));
        Assert.assertEquals((long)size, (long)this.mTestStream.read(readBytes));
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)size, (int)size, (byte[])readBytes));
        Assert.assertEquals((long)1L, (long)this.mTestStream.read(readBytes, size - 1, 1));
        Assert.assertEquals((long)(size * 2), (long)readBytes[size - 1]);
    }
}

